package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import java.util.Optional;
import net.minecraft.class_3611;
import net.minecraft.class_4551;
import net.minecraft.class_4559;
import net.minecraft.class_638;
import net.minecraft.class_6885;
import net.minecraft.class_7924;

public interface FluidPredicateTooltip {
	static void addToBuilder(class_638 level, class_4551 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		Optional<class_6885<class_3611>> fluids = predicate.comp_2372();
		if (fluids.isPresent()) {
			addFluidsToBuilder(level, fluids.orElseThrow(), state, builder);
		}

		Optional<class_4559> properties = predicate.comp_1782();
		if (properties.isPresent()) {
			addPropertiesToBuilder(level, properties.orElseThrow(), state, builder);
		}
	}

	static String key(String key) {
		return PredicateTooltip.key("fluid.%s".formatted(key));
	}

	static void addFluidsToBuilder(class_638 level, class_6885<class_3611> fluids, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		PredicateTooltip.addRegisteredElementsToBuilder(
				level,
				key("matches"),
				class_7924.field_41270,
				fluids,
				fluid -> fluid.method_15785().method_15759().method_26204().method_9518(),
				state,
				builder
		);
	}

	static void addPropertiesToBuilder(class_638 level, class_4559 properties, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		BlockPredicateTooltip.addStatePropertiesPredicateToBuilder(level, properties, state, builder);
	}
}
