package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.version.VRegistry;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1934;
import net.minecraft.class_2048;
import net.minecraft.class_2096;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4553;
import net.minecraft.class_638;
import net.minecraft.class_9789;

//? if >=1.21.8
/*import net.minecraft.advancements.critereon.InputPredicate;*/

public interface PlayerPredicateTooltip {
	static void addToBuilder(class_638 level, class_4553 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		class_2096.class_2100 playerLevel = predicate.comp_1817();
		addLevelToBuilder(level, playerLevel, state, builder);

		class_9789 gameType = predicate.comp_1818();
		addGameTypeToBuilder(level, gameType, state, builder);

		List<class_4553.class_8749<?>> stats = predicate.comp_1819();
		addStatsToBuilder(level, stats, state, builder);

		//? if >=1.21.8 {
		/*Object2BooleanMap<ResourceKey<Recipe<?>>> recipes = predicate.recipes();
		*///?} else {
		Object2BooleanMap<class_2960> recipes = predicate.comp_1820();
		 //?}
		addRecipesToBuilder(level, recipes, state, builder);

		Map<class_2960, class_4553.class_4556> advancements = predicate.comp_1821();
		addAdvancementsToBuilder(level, advancements, state, builder);

		Optional<class_2048> lookingAt = predicate.comp_1822();
		if (lookingAt.isPresent()) {
			addLookingAtToBuilder(level, lookingAt.orElseThrow(), state, builder);
		}

		//? if >=1.21.8 {
		/*Optional<InputPredicate> input = predicate.input();
		if (input.isPresent()) {
			addInputToBuilder(level, input.orElseThrow(), state, builder);
		}
		*///?}
	}

	static String key(String key) {
		return PredicateTooltip.key("player.%s".formatted(key));
	}

	static void addLevelToBuilder(class_638 level, class_2096.class_2100 playerLevel, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		if (!playerLevel.method_9041()) {
			PredicateTooltip.addMinMaxToBuilder(key("level"), false, playerLevel, state, builder);
		}
	}

	static void addGameTypeToBuilder(class_638 level, class_9789 gameType, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		List<class_1934> types = gameType.comp_2829();
		if (!types.isEmpty()) {
			PredicateTooltip.addEnumListToBuilder(key("game_type"), types, class_1934::method_32763, state, builder);
		}
	}

	static void addStatsToBuilder(class_638 level, List<class_4553.class_8749<?>> stats, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		if (stats.isEmpty()) return;

		CompositeContainerComponent.Builder statsBuilder = CompositeContainerComponent.builder()
				.space()
				.translate(key("stats.matches"), Styler::condition)
				.space()
				.cycle(cycleBuilder -> {
					for (class_4553.class_8749<?> stat : stats) {
						CompositeContainerComponent.Builder cycledBuilder = CompositeContainerComponent.builder();
						cycledBuilder.textComponent(class_2561.method_43469(key("stat"), Styler.name(stat.comp_1825().method_30739().method_27661())))
								.space()
								.literal("[", Styler::condition);
						PredicateTooltip.addMinMaxToBuilder(key("stat.range"), false, stat.comp_1827(), state, cycledBuilder);
						cycledBuilder.literal("]", Styler::condition);
						cycleBuilder.component(cycledBuilder.build());
					}
				});
		builder.component(statsBuilder.build());
	}

	//? if >=1.21.8 {
	/*static void addRecipesToBuilder(ClientLevel level, Object2BooleanMap<ResourceKey<Recipe<?>>> recipes, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		if (recipes.isEmpty()) return;

		CompositeContainerComponent.Builder recipesBuilder = CompositeContainerComponent.builder()
				.space()
				.translate(key("recipes.matches"), Styler::condition)
				.space()
				.cycle(cycleBuilder -> recipes.object2BooleanEntrySet().forEach(entry -> {
					boolean knows = entry.getBooleanValue();
					ResourceLocation id = entry.getKey().location();
					Component name = Styler.name(Component.literal(id.toString()));
					cycleBuilder.component(CompositeContainerComponent.builder()
							.translate(key("recipe.%s".formatted(knows ? "knows" : "does_not_know")), Styler::condition, name)
							.build());
				}));
		builder.component(recipesBuilder.build());
	}
	*///?} else {
	static void addRecipesToBuilder(class_638 level, Object2BooleanMap<class_2960> recipes, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		if (recipes.isEmpty()) return;

		CompositeContainerComponent.Builder recipesBuilder = CompositeContainerComponent.builder()
				.space()
				.translate(key("recipes.matches"), Styler::condition)
				.space()
				.cycle(cycleBuilder -> recipes.object2BooleanEntrySet().forEach(entry -> {
					boolean knows = entry.getBooleanValue();
					class_2960 id = entry.getKey();
					class_2561 name = Styler.name(class_2561.method_43470(id.toString()));
					cycleBuilder.component(CompositeContainerComponent.builder()
							.translate(key("recipe.%s".formatted(knows ? "knows" : "does_not_know")), Styler::condition, name)
							.build());
				}));
		builder.component(recipesBuilder.build());
	}
	//?}

	static void addAdvancementsToBuilder(class_638 level, Map<class_2960, class_4553.class_4556> advancements, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		if (advancements.isEmpty()) return;

		Registry<Advancement> registry = VRegistry.get(level, Registries.ADVANCEMENT);
		CompositeContainerComponent.Builder advancementsBuilder = CompositeContainerComponent.builder()
				.space()
				.translate(key("advancements.matches"), Styler::condition)
				.space()
				.cycle(cycleBuilder -> advancements.forEach((id, advancementPredicate) -> {
					Advancement advancement = registry.getOptional(id).orElse(null);
					if (advancement == null) return;

					Component name = Styler.name(advancement.name().orElse(Component.literal(id.toString())).copy());
					CompositeContainerComponent.Builder advancementBuilder = CompositeContainerComponent.builder()
							.textComponent(name);
					switch (advancementPredicate) {
						case PlayerPredicate.AdvancementDonePredicate donePredicate -> {
							boolean isDone = donePredicate.state();
							advancementBuilder.translate(key("advancement.%s".formatted(isDone ? "completed" : "not_completed")), Styler::value);
						}
						case PlayerPredicate.AdvancementCriterionsPredicate criterionsPredicate -> {
							Object2BooleanMap<String> criterions = criterionsPredicate.criterions();
							if (!criterions.isEmpty()) {
								advancementBuilder.space().literal("[");
								boolean useAnd = false;
								for (Map.Entry<String, Boolean> entry : criterions.object2BooleanEntrySet()) {
									if (useAnd) {
										advancementBuilder.literal(" & ");
									}
									useAnd = true;

									String criterion = entry.getKey();
									boolean achieved = entry.getValue();
									advancementBuilder.translate(
											key("advancement.criterion.%s".formatted(achieved ? "achieved" : "not_achieved")),
											Styler::value,
											Styler.name(Component.literal(criterion))
									);
								}
								advancementBuilder.literal("]");
							}
						}
						default -> {
						}
					}
					cycleBuilder.component(advancementBuilder.build());
				}));
		builder.component(advancementsBuilder.build());
	}

	static void addLookingAtToBuilder(class_638 level, class_2048 entityPredicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		EntityPredicateTooltip.addEntityPredicateToBuilder(level, "looking_at", entityPredicate, state, builder);
	}

	//? if >=1.21.8 {
	/*static void addInputToBuilder(ClientLevel level, InputPredicate inputPredicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		Map<String, Optional<Boolean>> inputs = Map.of(
				"forward", inputPredicate.forward(),
				"backward", inputPredicate.backward(),
				"left", inputPredicate.left(),
				"right", inputPredicate.right(),
				"jump", inputPredicate.jump(),
				"sneak", inputPredicate.sneak(),
				"sprint", inputPredicate.sprint()
		);
		CompositeContainerComponent.Builder inputBuilder = CompositeContainerComponent.builder()
				.space()
				.translate(key("input.matches"), Styler::condition)
				.space()
				.cycle(cycleBuilder -> inputs.forEach((inputName, input) -> {
					if (input.isPresent()) {
						boolean isHeld = input.orElse(false);
						cycleBuilder.component(CompositeContainerComponent.builder()
								.translate(key("input.%s.%s".formatted(inputName, isHeld ? "true" : "false")), Styler::value)
								.build());
					}
				}));
		builder.component(inputBuilder.build());
	}
	*///?}
}
