package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.exact;

import com.bawnorton.bettertrims.client.mixin.accessor.AdventureModePredicateAccessor;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.BlockPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.util.List;
import net.minecraft.class_4550;
import net.minecraft.class_638;
import net.minecraft.class_6538;

public record AdventureModePredicateExactAdder(String prefix) implements ExactAdder<class_6538> {
	@Override
	public void addToBuilder(class_638 level, class_6538 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		AdventureModePredicateAccessor accessor = (AdventureModePredicateAccessor) predicate;
		List<class_4550> blockPredicates = accessor.bettertrims$predicates();
		if (blockPredicates.isEmpty()) {
			builder.translate(key("%s.any".formatted(prefix)), Styler::condition);
		} else {
			CompositeContainerComponent.Builder canBreakBuilder = CompositeContainerComponent.builder()
					.space()
					.translate(key(prefix), Styler::condition)
					.space()
					.cycle(cycleBuilder -> blockPredicates.forEach(blockPredicate -> {
						CompositeContainerComponent.Builder blockBuilder = CompositeContainerComponent.builder();
						BlockPredicateTooltip.addToBuilder(level, blockPredicate, state, blockBuilder);
						cycleBuilder.component(blockBuilder.build());
					}));
			builder.component(canBreakBuilder.build());
		}
	}
}
