package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.exact;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.version.VRegistry;
import java.util.function.Function;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;

public record EnchantmentsExactAdder(String prefix) implements ExactAdder<class_9304> {
	@Override
	public void addToBuilder(class_638 level, class_9304 enchantments, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		if (enchantments.method_57543()) {
			builder.translate(key("%s.any".formatted(prefix)), Styler::condition);
		} else {
			class_2378<class_1887> registry = VRegistry.get(level, class_7924.field_41265);
			CompositeContainerComponent.Builder enchantmentsBuilder = CompositeContainerComponent.builder()
					.space()
					.translate(key(prefix), Styler::condition)
					.space()
					.cycle(cycleBuilder -> enchantments.method_57539().forEach(entry -> {
						class_6880<class_1887> key = entry.getKey();
						class_1887 enchantment = key.method_40229().map(registry::method_31140, Function.identity());
						int enchantmentLevel = entry.getIntValue();
						cycleBuilder.component(CompositeContainerComponent.builder()
								.translate(
										key("%s.entry".formatted(prefix)),
										Styler::condition,
										Styler.name(enchantment.comp_2686().method_27661()),
										Styler.number(enchantmentLevel)
								)
								.build());
					}));
			builder.component(enchantmentsBuilder.build());
		}
	}
}
