package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.exact;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.ExactDataComponentPredicateTooltipAdders;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import net.minecraft.class_9331;

public interface ExactAdder<T> {
	Function<class_9331<?>, ExactAdder<?>> UNKNOWN = type -> (level, object, state, builder) -> builder.translate(
			ExactDataComponentPredicateTooltipAdders.key("unknown_type"),
			Styler::property,
			Objects.requireNonNullElse(class_7923.field_49658.method_10221(type), "[unregistred]").toString()
	);

	void addToBuilder(class_638 level, T object, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder);

	default String key(String key) {
		return ExactDataComponentPredicateTooltipAdders.key(key);
	}

	static <T> ExactAdder<T> simple(BiConsumer<T, CompositeContainerComponent.Builder> consumer) {
		return (level, object, state, builder) -> {
			consumer.accept(object, builder);
		};
	}

	static <T extends Enum<T>> ExactAdder<T> ofEnum(String key) {
		return simple((enumInstance, builder) -> builder.translate(
				ExactDataComponentPredicateTooltipAdders.key(key),
				Styler::condition,
				Styler.value(class_2561.method_43470(StringUtils.capitalize(enumInstance.name()))))
		);
	}
}