package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.partial;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.util.Optional;
import net.minecraft.class_638;
import net.minecraft.class_9283;
import net.minecraft.class_9657;

public final class FireworkPredicateAdder implements PredicateAdder</*$ firework_explosion_predicate >>*/ class_9657 .class_9658> {
		@Override
		public void addToBuilder(class_638 level,/*$ firework_explosion_predicate >>*/ class_9657 .class_9658 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
			Optional<class_9283.class_1782> shape = predicate.comp_2633();
			Optional<Boolean> trail = predicate.comp_2635();
			Optional<Boolean> twinkle = predicate.comp_2634();

			boolean useAnd = false;
			builder.space();
			if (shape.isEmpty() && trail.isEmpty() && twinkle.isEmpty()) {
				builder.translate(key("firework.any"), Styler::condition);
				return;
			}

			builder.translate(key("firework.matches"), Styler::condition).space();

			if (shape.isPresent()) {
				builder.translate(key("firework.shape"), Styler::condition, Styler.name(shape.orElseThrow().method_7812()));
				useAnd = true;
			}

			if (trail.isPresent()) {
				if (useAnd) {
					builder.space()
							.translate("bettertrims.tooltip.and", Styler::condition)
							.space();
				}
				builder.translate(
						key(trail.orElseThrow() ? "firework.trail" : "firework.no_trail"),
						Styler::condition
				);
				useAnd = true;
			}

			if (twinkle.isPresent()) {
				if (useAnd) {
					builder.space()
							.translate("bettertrims.tooltip.and", Styler::condition)
							.space();
				}
				builder.translate(
						key(twinkle.orElseThrow() ? "firework.twinkle" : "firework.no_twinkle"),
						Styler::condition
				);
			}
		}
	}