package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.partial;

import com.bawnorton.bettertrims.client.tooltip.TrimTooltipPage;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.util.Optional;
import net.minecraft.class_638;
import net.minecraft.class_6885;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9660;

public final class TrimPredicatePartialAdder implements PartialAdder</*$ trim_predicate >>*/ class_9660 > {
	@Override
	public void addToBuilder(class_638 level, /*$ trim_predicate >>*/ class_9660 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		Optional<class_6885<class_8056>> pattern = predicate.comp_2639();
		Optional<class_6885<class_8054>> material = predicate.comp_2638();
		if (pattern.isEmpty() && material.isEmpty()) {
			builder.space().translate(key("armor_trim.any"), Styler::condition);
			return;
		}

		builder.space()
				.translate(key("armor_trim.matches"), Styler::condition)
				.space()
				.centred(true)
				.component(TrimTooltipPage.generateMatcherComponent(level, material.orElse(class_6885.method_40246()), pattern.orElse(class_6885.method_40246())));
	}
}
