package com.bawnorton.bettertrims.property;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.data.BetterTrimsDimensionTypeTags;
import com.bawnorton.bettertrims.data.BetterTrimsEntityTypeTags;
import com.bawnorton.bettertrims.data.TrimMaterialTags;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.type.TrimValueAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.ApplyMobEffectAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.PlaySoundAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.SpawnParticlesAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.SummonEntityAbility;
import com.bawnorton.bettertrims.property.ability.type.misc.DamageImmunityAbility;
import com.bawnorton.bettertrims.property.ability.type.misc.PiglinSafeAbility;
import com.bawnorton.bettertrims.property.ability.type.toggle.AttributeAbility;
import com.bawnorton.bettertrims.property.ability.type.toggle.ToggleMobEffectAbility;
import com.bawnorton.bettertrims.property.condition.DimensionCheck;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.bawnorton.bettertrims.property.item.TrimItemPropertyComponents;
import com.bawnorton.bettertrims.property.item.type.DamageImmunityItemProperty;
import com.bawnorton.bettertrims.registry.BetterTrimsAttributes;
import com.bawnorton.bettertrims.registry.BetterTrimsRegistries;
import net.minecraft.advancements.critereon.*;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_190;
import net.minecraft.class_1937;
import net.minecraft.class_2022;
import net.minecraft.class_2035;
import net.minecraft.class_2048;
import net.minecraft.class_2050;
import net.minecraft.class_207;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_212;
import net.minecraft.class_215;
import net.minecraft.class_219;
import net.minecraft.class_223;
import net.minecraft.class_2246;
import net.minecraft.class_227;
import net.minecraft.class_2398;
import net.minecraft.class_2874;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3735;
import net.minecraft.class_42;
import net.minecraft.class_4571;
import net.minecraft.class_47;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_5862;
import net.minecraft.class_5866;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_8057;
import net.minecraft.class_8103;
import net.minecraft.class_8129;
import net.minecraft.class_8548;
import net.minecraft.class_9356;
import net.minecraft.class_9361;
import net.minecraft.class_9660;
import net.minecraft.class_9734;
import net.minecraft.class_9750;
import net.minecraft.world.level.storage.loot.predicates.*;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Optional;
//? if >=1.21.8 {
/*import net.minecraft.advancements.critereon.ItemSubPredicates;
*///?}

public interface TrimProperties {
	class_5321<TrimProperty> CONDUCTIVE = key("conductive");
	class_5321<TrimProperty> CHARGED = key("charged");
	class_5321<TrimProperty> FIREPROOF = key("fireproof");
	class_5321<TrimProperty> IMPROVED_TRADING = key("improved_trading");
	class_5321<TrimProperty> INCREASE_EXPERIENCE_GAIN = key("increase_experience_gain");
	class_5321<TrimProperty> INCREASE_MINING_SPEED = key("increase_mining_speed");
	class_5321<TrimProperty> INCREASE_MOVEMENT_SPEED = key("increase_movement_speed");
	class_5321<TrimProperty> LUNAR_BONUSES = key("lunar_bonuses");
	class_5321<TrimProperty> TOUGHER = key("tougher");
	class_5321<TrimProperty> RESILIENT = key("resilient");
	class_5321<TrimProperty> RESONANT = key("resonant");
	class_5321<TrimProperty> SHADOWY = key("shadowy");
	class_5321<TrimProperty> SOLAR_BONUSES = key("solar_bonuses");
	class_5321<TrimProperty> WEARING_GOLD = key("wearing_gold");

	class_5321<TrimProperty> BOLT = key("bolt");
	class_5321<TrimProperty> COAST = key("coast");
	class_5321<TrimProperty> DUNE = key("dune");
	class_5321<TrimProperty> EYE = key("eye");
	class_5321<TrimProperty> FLOW = key("flow");
	class_5321<TrimProperty> HOST = key("host");
	class_5321<TrimProperty> RAISER = key("raiser");
	class_5321<TrimProperty> RIB = key("rib");
	class_5321<TrimProperty> SENTRY = key("sentry");
	class_5321<TrimProperty> SHAPER = key("shaper");
	class_5321<TrimProperty> SILENCE = key("silence");
	class_5321<TrimProperty> SNOUT = key("snout");
	class_5321<TrimProperty> SPIRE = key("spire");
	class_5321<TrimProperty> TIDE = key("tide");
	class_5321<TrimProperty> VEX = key("vex");
	class_5321<TrimProperty> WARD = key("ward");
	class_5321<TrimProperty> WAYFINDER = key("wayfinder");
	class_5321<TrimProperty> WILD = key("wild");

	static void bootstrap(class_7891<TrimProperty> context) {
		class_7871<class_8054> materialGetter = context.method_46799(class_7924.field_42083);
		class_7871<class_1299<?>> entityTypeGetter = context.method_46799(class_7924.field_41266);
		class_7871<class_1887> enchantmentGetter = context.method_46799(class_7924.field_41265);
		class_7871<class_2874> dimensionGetter = context.method_46799(class_7924.field_41241);
		class_7871<class_3414> soundEventGetter = context.method_46799(class_7924.field_41225);
		register(
				context, SHADOWY, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.RESIN)).ability(
						TrimAbilityComponents.TICK,
						new SpawnParticlesAbility(
								class_2398.field_47493,
								class_9734.method_60252(),
								class_9734.method_60252(),
								class_9734.method_60253(-0.2F),
								class_9734.method_60250(class_5862.method_33908(0.1F)),
								class_5862.method_33908(0.5f)
						),
						class_215.method_917(
								class_47.class_50.field_935,
								class_2048.class_2049.method_8916().method_59930(class_9750.method_60279(class_2096.class_2099.method_9050(0.1)))
						)
				).ability(
						TrimAbilityComponents.TICK,
						new SpawnParticlesAbility(
								class_2398.field_22247,
								class_9734.method_60252(),
								class_9734.method_60252(),
								class_9734.method_60250(class_5862.method_33908(0)),
								class_9734.method_60250(class_5862.method_33908(0)),
								class_5862.method_33908(0)
						),
						class_215.method_917(
								class_47.class_50.field_935,
								class_2048.class_2049.method_8916().method_59930(class_9750.method_60279(class_2096.class_2099.method_35286(0.1)))
						)
				).ability(
						TrimAbilityComponents.EQUIPPED,
						new AttributeAbility(
								BetterTrims.rl("trim_true_invisibility"),
								BetterTrimsAttributes.TRUE_INVISIBILITY,
								CountBasedValue.constant(1),
								class_1322.class_1323.field_6328
						),
						class_215.method_917(
								class_47.class_50.field_935,
								class_2048.class_2049.method_8916().method_59930(class_9750.method_60279(class_2096.class_2099.method_35286(0.1)))
						)
				).ability(
						TrimAbilityComponents.DAMAGE,
						TrimValueAbility.multiply(CountBasedValue.linear(1.25f, 0.25f)),
						class_215.method_917(
								class_47.class_50.field_935,
								class_2048.class_2049.method_8916().method_59930(class_9750.method_60279(class_2096.class_2099.method_35286(0.1)))
						)
				).build()
		);
		register(
				context,
				WEARING_GOLD,
				TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.GOLD)).ability(TrimAbilityComponents.PIGLIN_SAFE, PiglinSafeAbility.INSTANCE).build()
		);
		register(
				context, INCREASE_MINING_SPEED, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.IRON))
						.ability(
								TrimAbilityComponents.EQUIPPED,
								new AttributeAbility(BetterTrims.rl("trim_mining_speed"), class_5134.field_51581, CountBasedValue.countSquared(1), class_1322.class_1323.field_6328)
						)
						.ability(
								TrimAbilityComponents.EQUIPPED,
								new ToggleMobEffectAbility(class_1294.field_5917, CountBasedValue.constant(1)),
								wearingFullSet(materialGetter, TrimMaterialTags.IRON)
						)
						.build()
		);
		register(
				context, RESILIENT, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.DIAMOND)).ability(
						TrimAbilityComponents.INCOMING_DAMAGE,
						TrimValueAbility.multiply(CountBasedValue.linear(0.95f, -0.05f)),
						class_190.method_837(class_2022.class_2023.method_8855().method_48785(class_8129.method_48968(class_8103.field_42244)))
				).ability(
						TrimAbilityComponents.ITEM_DAMAGE,
						TrimValueAbility.removeBinomial(CountBasedValue.fraction(CountBasedValue.linear(1), CountBasedValue.linear(4, 1))),
						class_223.method_945(itemMaterialPredicate(materialGetter, TrimMaterialTags.DIAMOND))
				).build()
		);
		register(
				context, RESONANT, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.AMETHYST)).ability(
						TrimAbilityComponents.POST_ATTACK,
						new PlaySoundAbility(
								class_6880.method_40223(class_3417.field_43154),
								class_5866.method_33934(0.8f, 1.2f),
								class_5866.method_33934(0.8f, 1.2f)
						)
				).ability(
						TrimAbilityComponents.HIT_BLOCK,
						new PlaySoundAbility(
								class_6880.method_40223(class_3417.field_43154),
								class_5866.method_33934(0.8f, 1.2f),
								class_5866.method_33934(0.8f, 1.2f)
						)
				).ability(
						TrimAbilityComponents.INCOMING_DAMAGE,
						TrimValueAbility.multiply(CountBasedValue.clamped(CountBasedValue.linear(0.75f, -0.25f), 0, 1f)),
						class_219.method_932(0.05f)
				).ability(
						TrimAbilityComponents.DAMAGE,
						TrimValueAbility.multiply(CountBasedValue.linear(5)),
						class_219.method_932(0.05f)
				).build()
		);
		register(
				context, TOUGHER, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.NETHERITE)).ability(
						TrimAbilityComponents.EQUIPPED, AllOf.toggleAbilities(
								new AttributeAbility(BetterTrims.rl("trim_armour_toughness"), class_5134.field_23725, CountBasedValue.linear(1), class_1322.class_1323.field_6328),
								new AttributeAbility(BetterTrims.rl("trim_armour"), class_5134.field_23724, CountBasedValue.linear(2), class_1322.class_1323.field_6328)
						)
				).ability(
						TrimAbilityComponents.ITEM_DAMAGE,
						TrimValueAbility.removeBinomial(CountBasedValue.fraction(CountBasedValue.linear(1), CountBasedValue.linear(2, 1))),
						class_223.method_945(itemMaterialPredicate(materialGetter, TrimMaterialTags.NETHERITE))
				).build()
		);
		register(
				context,
				FIREPROOF,
				TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.NETHERITE))
						.ability(TrimAbilityComponents.EQUIPPED, new ToggleMobEffectAbility(class_1294.field_5918, CountBasedValue.constant(0)))
						.itemProperty(
								TrimItemPropertyComponents.DAMAGE_IMMUNITY,
								DamageImmunityItemProperty.INSTANCE,
								class_190.method_837(class_2022.class_2023.method_8855()
										.method_48785(class_8129.method_48965(class_8103.field_42246))
										.method_48785(class_8129.method_48968(class_8103.field_42242)))
						)
						.build()
		);
		register(
				context,
				INCREASE_EXPERIENCE_GAIN,
				TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.QUARTZ))
						.ability(TrimAbilityComponents.EXPERIENCE_GAINED, TrimValueAbility.multiply(CountBasedValue.linear(1.25f, 0.25f)))
						.build()
		);
		register(
				context, INCREASE_MOVEMENT_SPEED, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.REDSTONE)).ability(
						TrimAbilityComponents.EQUIPPED,
						new AttributeAbility(
								BetterTrims.rl("trim_movement_speed"),
								class_5134.field_23719,
								CountBasedValue.linear(0.12f),
								class_1322.class_1323.field_6331
						)
				).build()
		);
		register(
				context, CONDUCTIVE, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.COPPER)).ability(
						TrimAbilityComponents.DAMAGE_IMMUNITY,
						DamageImmunityAbility.INSTANCE,
						class_190.method_837(class_2022.class_2023.method_8855()
								.method_48785(class_8129.method_48965(class_8103.field_42253))
								.method_48785(class_8129.method_48968(class_8103.field_42242)))
				).itemProperty(
						TrimItemPropertyComponents.DAMAGE_IMMUNITY,
						DamageImmunityItemProperty.INSTANCE,
						class_190.method_837(class_2022.class_2023.method_8855()
								.method_48785(class_8129.method_48965(class_8103.field_42253))
								.method_48785(class_8129.method_48968(class_8103.field_42242)))
				).build()
		);
		register(
				context, CHARGED, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.COPPER)).ability(
						TrimAbilityComponents.PROJECTILE_TICK, new SpawnParticlesAbility(
								class_2398.field_29644,
								class_9734.method_60249(0),
								class_9734.method_60249(0),
								class_9734.method_60253(-0.5f),
								class_9734.method_60253(-0.5f),
								class_5862.method_33908(1)
						), class_215.method_917(
								class_47.class_50.field_935,
								class_2048.class_2049.method_8916().method_8917(getEntityTypePredicate(entityTypeGetter, BetterTrimsEntityTypeTags.CONDUCTIVE_PROJECTILES))
						)
				).ability(
						TrimAbilityComponents.DAMAGE,
						TrimValueAbility.add(CountBasedValue.linear(0.5F)),
						class_215.method_917(
								class_47.class_50.field_939,
								class_2048.class_2049.method_8916().method_8917(getEntityTypePredicate(entityTypeGetter, BetterTrimsEntityTypeTags.CONDUCTIVE_PROJECTILES))
						)
				).ability(
						TrimAbilityComponents.POST_ATTACK,
						AllOf.entityAbilities(
								new SummonEntityAbility(class_1299.field_6112),
								new PlaySoundAbility(class_3417.field_14896, class_5862.method_33908(5F), class_5862.method_33908(1F))
						),
						class_8548.method_51723(
								class_227.method_35564().method_35567(true),
								class_215.method_917(
										class_47.class_50.field_935,
										class_2048.class_2049.method_8916().method_8918(class_2090.class_2091.method_22484().method_60275(true))
								),
								class_215.method_917(
										class_47.class_50.field_939,
										class_2048.class_2049.method_8916().method_8917(getEntityTypePredicate(entityTypeGetter, BetterTrimsEntityTypeTags.CONDUCTIVE_PROJECTILES))
								),
								class_207.method_889(class_223.method_945(itemEnchantedPredicate(enchantmentGetter, class_1893.field_9117)))
						)
				).ability(
						TrimAbilityComponents.HIT_BLOCK,
						AllOf.entityAbilities(
								new SummonEntityAbility(class_1299.field_6112),
								new PlaySoundAbility(class_3417.field_14896, class_5862.method_33908(5.0F), class_5862.method_33908(1.0F))
						),
						class_8548.method_51723(
								class_227.method_35564().method_35567(true),
								class_215.method_917(
										class_47.class_50.field_935,
										class_2048.class_2049.method_8916().method_8917(getEntityTypePredicate(entityTypeGetter, BetterTrimsEntityTypeTags.CONDUCTIVE_PROJECTILES))
								),
								class_212.method_900(class_2246.field_27171),
								class_207.method_889(class_223.method_945(itemEnchantedPredicate(enchantmentGetter, class_1893.field_9117)))
						)
				).build()
		);
		register(
				context, SOLAR_BONUSES, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.GOLD)).ability(
						TrimAbilityComponents.EQUIPPED,
						AllOf.toggleAbilities(
								new AttributeAbility(
										BetterTrims.rl("trim_solar_bonus_attack_damage"),
										class_5134.field_23721,
										CountBasedValue.linear(1),
										class_1322.class_1323.field_6328
								),
								new AttributeAbility(
										BetterTrims.rl("trim_solar_bonus_movement_speed"),
										class_5134.field_23719,
										CountBasedValue.linear(0.07f),
										class_1322.class_1323.field_6331
								),
								new AttributeAbility(BetterTrims.rl("trim_solar_bonus_armour"), class_5134.field_23724, CountBasedValue.linear(1), class_1322.class_1323.field_6328),
								new AttributeAbility(
										BetterTrims.rl("trim_solar_bonus_attack_speed"),
										class_5134.field_23723,
										CountBasedValue.linear(0.5f),
										class_1322.class_1323.field_6328
								)
						),
						class_8548.method_51723(
								class_4571.method_35559(class_42.method_277(13000)).method_35560(24000),
								DimensionCheck.of(dimensionGetter.method_46735(BetterTrimsDimensionTypeTags.HAS_SUN))
						)
				).build()
		);
		register(
				context, LUNAR_BONUSES, TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.SILVER)).ability(
						TrimAbilityComponents.EQUIPPED,
						AllOf.toggleAbilities(
								new AttributeAbility(
										BetterTrims.rl("trim_lunar_bonus_attack_damage"),
										class_5134.field_23721,
										CountBasedValue.linear(1),
										class_1322.class_1323.field_6328
								),
								new AttributeAbility(
										BetterTrims.rl("trim_lunar_bonus_movement_speed"),
										class_5134.field_23719,
										CountBasedValue.linear(0.07f),
										class_1322.class_1323.field_6331
								),
								new AttributeAbility(BetterTrims.rl("trim_lunar_bonus_armour"), class_5134.field_23724, CountBasedValue.linear(1), class_1322.class_1323.field_6328),
								new AttributeAbility(
										BetterTrims.rl("trim_lunar_bonus_attack_speed"),
										class_5134.field_23723,
										CountBasedValue.linear(0.05f),
										class_1322.class_1323.field_6331
								)
						),
						class_8548.method_51723(
								class_4571.method_35559(class_42.method_280(13000)).method_35560(24000),
								DimensionCheck.of(dimensionGetter.method_46735(BetterTrimsDimensionTypeTags.HAS_MOON))
						)
				).ability(
						TrimAbilityComponents.EQUIPPED,
						new ToggleMobEffectAbility(class_1294.field_5925, CountBasedValue.constant(0)),
						wearingInSlot(materialGetter, TrimMaterialTags.SILVER, class_1304.field_6169)
				).build()
		);
		register(
				context,
				IMPROVED_TRADING,
				TrimProperty.builder(getMaterialMatcher(materialGetter, TrimMaterialTags.EMERALD))
						.ability(TrimAbilityComponents.TRADE_COST, TrimValueAbility.multiply(CountBasedValue.linear(0.9f, -0.1f)))
						.build()
		);
	}

	static void bootstrapTrimEffects(class_7891<TrimProperty> context) {
		registerTrimEffect(context, BOLT, class_8057.field_49828, class_1294.field_5900);
		registerTrimEffect(context, COAST, class_8057.field_42018, class_1294.field_5923);
		registerTrimEffect(context, DUNE, class_8057.field_42017, class_1294.field_5904);
		registerTrimEffect(context, EYE, class_8057.field_42021, class_1294.field_5924);
		registerTrimEffect(context, FLOW, class_8057.field_49827, class_1294.field_5913);
		registerTrimEffect(context, HOST, class_8057.field_43225, class_1294.field_5912);
		registerTrimEffect(context, RAISER, class_8057.field_43224, class_1294.field_5922);
		registerTrimEffect(context, RIB, class_8057.field_42025, class_1294.field_5917);
		registerTrimEffect(context, SENTRY, class_8057.field_42016, class_1294.field_5907);
		registerTrimEffect(context, SHAPER, class_8057.field_43222, class_1294.field_5926);
		registerTrimEffect(context, SILENCE, class_8057.field_43223, class_1294.field_5914);
		registerTrimEffect(context, SNOUT, class_8057.field_42024, class_1294.field_5918);
		registerTrimEffect(context, SPIRE, class_8057.field_42026, class_1294.field_5910);
		registerTrimEffect(context, TIDE, class_8057.field_42023, class_1294.field_5927);
		registerTrimEffect(context, VEX, class_8057.field_42022, class_1294.field_5905);
		registerTrimEffect(context, WAYFINDER, class_8057.field_43221, class_1294.field_5906);
		registerTrimEffect(context, WILD, class_8057.field_42019, class_1294.field_18980);

		register(
				context,
				WARD,
				TrimProperty.builder(Matcher.forPattern(class_6885.method_40246(context.method_46799(class_7924.field_42082).method_46747(class_8057.field_42020)), 2)).ability(
						TrimAbilityComponents.SECOND,
						new ApplyMobEffectAbility(
								class_1294.field_5898,
								CountBasedValue.lookup(List.of(-1F, 0F, 0F, 1F), CountBasedValue.constant(0)),
								CountBasedValue.constant(16)
						),
						class_215.method_917(
								class_47.class_50.field_935,
								new class_2048.class_2049().method_59929(300)
						)
				).build()
		);
	}

	private static void registerTrimEffect(class_7891<TrimProperty> context, class_5321<TrimProperty> key, class_5321<class_8056> pattern, class_6880<class_1291> effect) {
		register(
				context,
				key,
				TrimProperty.builder(Matcher.forPattern(class_6885.method_40246(context.method_46799(class_7924.field_42082).method_46747(pattern)), 2)).ability(
						TrimAbilityComponents.SECOND,
						new ApplyMobEffectAbility(effect, CountBasedValue.lookup(List.of(-1F, 0F, 0F, 1F), CountBasedValue.constant(0)), CountBasedValue.constant(9))
				).build()
		);
	}

	private static class_2050 getEntityTypePredicate(class_7871<class_1299<?>> entityTypeGetter, class_6862<class_1299<?>> tag) {
		//? if >=1.21.8 {
		/*return EntityTypePredicate.of(entityTypeGetter, tag);
		 *///?} else {
		return class_2050.method_8926(tag);
		 //?}
	}

	private static class_5341.class_210 wearingInSlot(class_7871<class_8054> materialGetter, class_6862<class_8054> material, class_1304 slot) {
		return class_215.method_917(
				class_47.class_50.field_935,
				class_2048.class_2049.method_8916().method_53141(addSlot(class_3735.class_5278.method_27965(), materialGetter, material, slot))
		);
	}

	private static class_5341.class_210 wearingFullSet(class_7871<class_8054> materialGetter, class_6862<class_8054> material) {
		return class_215.method_917(
				class_47.class_50.field_935,
				class_2048.class_2049.method_8916().method_53141(fullSetMaterialPredicate(materialGetter, material))
		);
	}

	private static class_3735.class_5278 fullSetMaterialPredicate(class_7871<class_8054> materialGetter, class_6862<class_8054> material) {
		class_3735.class_5278 builder = class_3735.class_5278.method_27965();
		for (class_1304 slot : List.of(class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166)) {
			addSlot(builder, materialGetter, material, slot);
		}
		return builder;
	}

	private static class_3735.class_5278 addSlot(class_3735.class_5278 builder, class_7871<class_8054> materialGetter, class_6862<class_8054> material, class_1304 slot) {
		switch (slot) {
			case field_6169 -> builder.method_27966(itemMaterialPredicate(materialGetter, material));
			case field_6174 -> builder.method_27968(itemMaterialPredicate(materialGetter, material));
			case field_6172 -> builder.method_27969(itemMaterialPredicate(materialGetter, material));
			case field_6166 -> builder.method_27970(itemMaterialPredicate(materialGetter, material));
			case field_48824 -> builder.method_59651(itemMaterialPredicate(materialGetter, material));
			case field_6173 -> builder.method_35195(itemMaterialPredicate(materialGetter, material));
			case field_6171 -> builder.method_35196(itemMaterialPredicate(materialGetter, material));
			default -> {
			}
		}
		return builder;
	}

	private static class_2073.class_2074 itemMaterialPredicate(class_7871<class_8054> materialGetter, class_6862<class_8054> material) {
		return class_2073.class_2074.method_8973()
		//? if >=1.21.8 {
				/*.withComponents(DataComponentMatchers.Builder.components()
						.partial(DataComponentPredicates.ARMOR_TRIM, new TrimPredicate(Optional.of(materialGetter.getOrThrow(material)), Optional.empty()))
						.build());
		*///?} else {
				.method_58179(
						class_9361.field_51393,
						new class_9660(
								Optional.of(materialGetter.method_46735(material)),
								Optional.empty()
						)
				);
		//?}
	}

	private static class_2073.class_2074 itemEnchantedPredicate(class_7871<class_1887> enchantmentGetter, class_5321<class_1887> enchantment) {
		return class_2073.class_2074.method_8973()
		//? if >=1.21.8 {
				/*.withComponents(DataComponentMatchers.Builder.components().partial(
						DataComponentPredicates.ENCHANTMENTS,
						EnchantmentsPredicate.Enchantments.enchantments(List.of(new EnchantmentPredicate(enchantmentGetter.getOrThrow(enchantment), MinMaxBounds.Ints.ANY)))
				).build());
		*///?} else {
				.method_58179(
						class_9361.field_49807,
						class_9356.method_58173(
								List.of(
										new class_2035(
												enchantmentGetter.method_46747(enchantment),
												class_2096.class_2100.field_9708
										)
								)
						)
				);
		//?}
	}

	private static @NotNull Matcher getMaterialMatcher(class_7871<class_8054> materialGetter, class_6862<class_8054> material) {
		return Matcher.forMaterial(materialGetter.method_46735(material), 1);
	}

	static Iterable<TrimProperty> getProperties(class_1937 level) {
		return level.method_30349()
				.method_46762(BetterTrimsRegistries.Keys.TRIM_PROPERTIES)
				.method_42017()
				.map(class_6880.class_6883::comp_349)::iterator;
	}

	private static void register(class_7891<TrimProperty> context, class_5321<TrimProperty> key, TrimProperty property) {
		context.method_46838(key, property);
	}

	private static class_5321<TrimProperty> key(String key) {
		return class_5321.method_29179(BetterTrimsRegistries.Keys.TRIM_PROPERTIES, BetterTrims.rl(key));
	}
}
