package com.bawnorton.bettertrims.property.ability.runner;

import com.bawnorton.bettertrims.property.Matcher;
import com.bawnorton.bettertrims.property.context.ContextChecker;
import com.bawnorton.bettertrims.property.ability.type.TrimValueAbility;
import com.bawnorton.bettertrims.property.context.TrimContexts;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_47;

public record TrimValueAbilityRunner<T extends TrimValueAbility>(T ability, Predicate<class_47> conditionChecker, Matcher matcher) implements ContextChecker {
	public float runEquipment(class_3218 level, class_1309 wearer, float value) {
		return runEquipment(level, wearer, null, value);
	}

	public float runEquipment(class_3218 level, class_1309 wearer, class_1799 stack, float value) {
		Map<class_1304, class_1799> matchingStacks = matcher.getMatchingStacks(wearer);
		TrimmedItems items = TrimmedItems.of(matchingStacks, wearer);
		if (items.size() >= matcher.minCount() && checkRequirement(TrimContexts.equipment(level, items, stack))) {
			return ability.process(items.size(), wearer.method_59922(), value);
		}
		return value;
	}

	public float runDamage(class_3218 level, class_1309 wearer, class_1282 damageSource, float value) {
		Map<class_1304, class_1799> matchingStacks = matcher.getMatchingStacks(wearer);
		TrimmedItems items = TrimmedItems.of(matchingStacks, wearer);
		if (items.size() >= matcher.minCount() && checkRequirement(TrimContexts.damage(level, items, wearer, damageSource))) {
			return ability.process(items.size(), wearer.method_59922(), value);
		}
		return value;
	}
}
