package com.bawnorton.bettertrims.property.ability.type;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.property.AllOf;
import com.bawnorton.bettertrims.property.ability.type.toggle.AttributeAbility;
import com.bawnorton.bettertrims.property.ability.type.toggle.ToggleMobEffectAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.property.element.TrimElement;
import com.bawnorton.bettertrims.registry.BetterTrimsRegistries;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_3218;

public interface TrimToggleAbility extends TrimElement {
	Codec<TrimToggleAbility> CODEC = BetterTrimsRegistries.TRIM_TOGGLE_ABILITY_TYPE
			.method_39673()
			.dispatch(TrimToggleAbility::codec, Function.identity());

	static MapCodec<? extends TrimToggleAbility> bootstrap(class_2378<MapCodec<? extends TrimToggleAbility>> registry) {
		class_2378.method_10230(registry, BetterTrims.rl("all_of"), AllOf.ToggleAbilities.CODEC);
		class_2378.method_10230(registry, BetterTrims.rl("attribute"), AttributeAbility.CODEC);
		return class_2378.method_10230(registry, BetterTrims.rl("toggle_mob_effect"), ToggleMobEffectAbility.CODEC);
	}

	void start(class_3218 level, class_1309 wearer, TrimmedItems items);

	default void stop(class_3218 level, class_1309 wearer, TrimmedItems items) {
	}

	MapCodec<? extends TrimToggleAbility> codec();
}
