package com.bawnorton.bettertrims.property.ability.type;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.property.AllOf;
import com.bawnorton.bettertrims.property.ability.type.value.AddValue;
import com.bawnorton.bettertrims.property.ability.type.value.MultiplyValue;
import com.bawnorton.bettertrims.property.ability.type.value.RemoveBinomial;
import com.bawnorton.bettertrims.property.ability.type.value.SetValue;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.bawnorton.bettertrims.property.element.TrimElement;
import com.bawnorton.bettertrims.registry.BetterTrimsRegistries;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_5819;

public interface TrimValueAbility extends TrimElement {
	Codec<TrimValueAbility> CODEC = BetterTrimsRegistries.TRIM_VALUE_ABILITY_TYPE
			.method_39673()
			.dispatch(TrimValueAbility::codec, Function.identity());

	static MapCodec<? extends TrimValueAbility> bootstrap(class_2378<MapCodec<? extends TrimValueAbility>> registry) {
		class_2378.method_10230(registry, BetterTrims.rl("add"), AddValue.CODEC);
		class_2378.method_10230(registry, BetterTrims.rl("all_of"), AllOf.ValueAbilities.CODEC);
		class_2378.method_10230(registry, BetterTrims.rl("multiply"), MultiplyValue.CODEC);
		class_2378.method_10230(registry, BetterTrims.rl("remove_binomial"), RemoveBinomial.CODEC);
		return class_2378.method_10230(registry, BetterTrims.rl("set"), SetValue.CODEC);
	}

	static AddValue add(CountBasedValue value) {
		return new AddValue(value);
	}

	static MultiplyValue multiply(CountBasedValue value) {
		return new MultiplyValue(value);
	}

	static RemoveBinomial removeBinomial(CountBasedValue chance) {
		return new RemoveBinomial(chance);
	}

	static SetValue set(CountBasedValue value) {
		return new SetValue(value);
	}

	float process(int count, class_5819 random, float value);

	@Override
	default boolean usesCount() {
		return true;
	}

	MapCodec<? extends TrimValueAbility> codec();
}