package com.bawnorton.bettertrims.property.ability.type.entity;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.ability.type.toggle.ToggleMobEffectAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.bawnorton.bettertrims.version.VRegistry;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public record ApplyMobEffectAbility(class_6880<class_1291> effect, CountBasedValue amplifier, CountBasedValue duration) implements TrimEntityAbility {
	public static final MapCodec<ApplyMobEffectAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
			class_1291.field_51933.fieldOf("effect").forGetter(ApplyMobEffectAbility::effect),
			CountBasedValue.CODEC.fieldOf("amplifier").forGetter(ApplyMobEffectAbility::amplifier),
			CountBasedValue.CODEC.fieldOf("duration").forGetter(ApplyMobEffectAbility::duration)
	).apply(instance, ApplyMobEffectAbility::new));

	@Override
	public void apply(class_3218 level, class_1309 wearer, class_1297 target, TrimmedItems items, @Nullable class_1304 targetSlot, class_243 origin) {
		if (target instanceof class_1309 living) {
			int count = items.size();
			int amplifier = (int) this.amplifier.calculate(count);
			int duration = (int) this.duration.calculate(count) * 20;
			if (amplifier < 0 || duration <= 0) return;

			class_1293 effectInstance = new class_1293(effect, duration, amplifier);
			living.method_6092(effectInstance);
		}
	}

	@Override
	public boolean usesCount() {
		return true;
	}

	@Override
	public MapCodec<? extends TrimEntityAbility> codec() {
		return CODEC;
	}

	public static class TooltipProvider implements TrimElementTooltipProvider<ApplyMobEffectAbility> {
		@Override
		public class_5684 getTooltip(class_638 level, ApplyMobEffectAbility element, boolean includeCount) {
			return getEffectTooltip(
					level,
					includeCount,
					element.effect(),
					element.amplifier(),
					(builder, styler) -> builder.translate("bettertrims.tooltip.ability.apply_mob_effect.for", styler)
							.cycle(durationCycler -> element.duration().getValueComponents(4, includeCount, f -> class_2561.method_43470("%.0f".formatted(f)), f -> f > 0)
									.forEach(durationCycler::textComponent))
							.translate("bettertrims.tooltip.ability.apply_mob_effect.seconds", styler)
							.build()
			);
		}

		public static class_5684 getEffectTooltip(
				class_638 level,
				boolean includeCount,
				class_6880<class_1291> effect,
				CountBasedValue amplifier,
				BiFunction<CompositeContainerComponent.Builder, UnaryOperator<class_2583>, CompositeContainerComponent> builder
		) {
			class_2378<class_1291> registry = VRegistry.get(level, class_7924.field_41208);
			class_1291 mobEffect = effect.method_40229().map(registry::method_31140, Function.identity());
			class_2561 name = Styler.name(mobEffect.method_5560().method_27661());

			List<class_2561> amplifierValues = amplifier.getValueComponents(
					4,
					includeCount,
					f -> class_2561.method_43471("enchantment.level.%s".formatted("%.0f".formatted(f + 1))),
					f -> f >= 0
			);
			return builder.apply(
					CompositeContainerComponent.builder()
							.translate("bettertrims.tooltip.ability.apply_mob_effect.grants", Styler.sentiment(mobEffect.method_5573()))
							.textComponent(name)
							.cycle(amplifierCycler -> amplifierValues.forEach(amplifierCycler::textComponent))
							.spaced(),
					Styler.sentiment(mobEffect.method_5573())
			);
		}
	}
}