package com.bawnorton.bettertrims.property.ability.type.entity;

import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.bawnorton.bettertrims.version.VRegistry;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;

public record DamageEntityAbility(CountBasedValue minDamage, CountBasedValue maxDamage, class_6880<class_8110> damageType) implements TrimEntityAbility {
	public static final MapCodec<DamageEntityAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
			CountBasedValue.CODEC.fieldOf("min_damage").forGetter(DamageEntityAbility::minDamage),
			CountBasedValue.CODEC.fieldOf("max_damage").forGetter(DamageEntityAbility::maxDamage),
			class_8110.field_51565.fieldOf("damage_type").forGetter(DamageEntityAbility::damageType)
	).apply(instance, DamageEntityAbility::new));

	@Override
	public void apply(class_3218 level, class_1309 wearer, class_1297 target, TrimmedItems items, @Nullable class_1304 targetSlot, class_243 origin) {
		int count = items.size();
		float damage = class_3532.method_32750(target.method_59922(), minDamage.calculate(count), maxDamage.calculate(count));
		//? if >=1.21.8 {
		/*target.hurtServer(level, new DamageSource(damageType, wearer), damage);
		 *///?} else {
		target.method_5643(new class_1282(damageType, wearer), damage);
		 //?}
	}

	@Override
	public boolean usesCount() {
		return true;
	}

	@Override
	public MapCodec<? extends TrimEntityAbility> codec() {
		return CODEC;
	}

	public static class TooltipProvider implements TrimElementTooltipProvider<DamageEntityAbility> {
		@Override
		public class_5684 getTooltip(class_638 level, DamageEntityAbility element, boolean includeCount) {
			class_2378<class_8110> registry = VRegistry.get(level, class_7924.field_42534);
			class_2960 type = element.damageType().method_40229().map(class_5321::method_29177, registry::method_10221);

			List<Float> minValues = element.minDamage().getValues(4);
			List<Float> maxValues = element.maxDamage().getValues(4);
			List<class_2561> components = new ArrayList<>();
			for (int i = 0; i < 4; i++) {
				components.add(Styler.trim(class_2561.method_43470("[%s]".formatted(i + 1)))
						.method_27693(": ")
						.method_10852(Styler.number(class_2561.method_43470("%.1f - %.1f".formatted(minValues.get(i), maxValues.get(i))))));
			}

			return CompositeContainerComponent.builder()
					.translate("bettertrims.tooltip.ability.damage_entity.deals", Styler::positive)
					.cycle(builder -> components.forEach(builder::textComponent))
					.literal(type.toString(), Styler::name)
					.translate("bettertrims.tooltip.ability.damage_entity.damage", Styler::positive)
					.spaced()
					.build();
		}
	}
}
