/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip;

import com.bawnorton.bettertrims.client.tooltip.ExpandedTooltipPositioner;
import com.bawnorton.bettertrims.client.tooltip.TrimTooltipPage;
import com.bawnorton.bettertrims.client.tooltip.component.GapComponent;
import com.bawnorton.bettertrims.property.Matcher;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.version.VGuiGraphics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;

public class TrimPropertiesTooltip {
    private final Map<Matcher, List<TrimProperty>> properties;
    private final List<TrimTooltipPage> pages;
    private int index;

    public TrimPropertiesTooltip(Map<Matcher, List<TrimProperty>> properties) {
        this.properties = properties;
        this.pages = new ArrayList<TrimTooltipPage>();
    }

    public void generatePages(ClientLevel level, Font font) {
        this.pages.clear();
        for (Map.Entry<Matcher, List<TrimProperty>> entry : this.properties.entrySet()) {
            Matcher matcher = entry.getKey();
            List<TrimProperty> properties = entry.getValue();
            for (TrimProperty property : properties) {
                TrimTooltipPage page = new TrimTooltipPage(property, matcher);
                this.pages.add(page);
            }
        }
        for (int i = 0; i < this.pages.size(); ++i) {
            this.pages.get(i).generateComponent(level, font, i, this.pages.size());
        }
    }

    public void render(GuiGraphics graphics, ClientLevel level, Font font, Rect2i parentTooltipBounds, boolean horizontallyFlipped, ResourceLocation background) {
        if (this.index >= this.pages.size()) {
            return;
        }
        TrimTooltipPage page = this.pages.get(this.index);
        ArrayList<ClientTooltipComponent> components = new ArrayList<ClientTooltipComponent>();
        components.add(page.getComponent());
        components.add(new GapComponent(page.getRenderedWidth(font), 0));
        int offsetX = parentTooltipBounds.getX() + parentTooltipBounds.getWidth() + (horizontallyFlipped ? 14 : 0);
        int offsetY = parentTooltipBounds.getY();
        VGuiGraphics.renderTooltip(graphics, font, components, offsetX, offsetY, new ExpandedTooltipPositioner(parentTooltipBounds.getWidth()), background);
    }

    public boolean mouseScrolled(double scrollY) {
        if (this.pages.size() <= 1) {
            return false;
        }
        if (scrollY > 0.0) {
            --this.index;
            if (this.index < 0) {
                this.index = this.pages.size() - 1;
            }
        } else if (scrollY < 0.0) {
            ++this.index;
            if (this.index >= this.pages.size()) {
                this.index = 0;
            }
        } else {
            return false;
        }
        return true;
    }
}

