/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.EntityPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.DataComponentMatchersTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringUtils;

public interface BlockPredicateTooltip {
    public static void addToBuilder(ClientLevel level, BlockPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Optional properties;
        Optional nbt;
        DataComponentMatchers components;
        Optional blocks = predicate.blocks();
        if (blocks.isPresent()) {
            BlockPredicateTooltip.addBlocksToBuilder(level, (HolderSet<Block>)((HolderSet)blocks.orElseThrow()), state, builder);
        }
        if (!(components = predicate.components()).isEmpty()) {
            BlockPredicateTooltip.addDataComponentMatchersToBuilder(level, components, state, builder);
        }
        if ((nbt = predicate.nbt()).isPresent()) {
            BlockPredicateTooltip.addNbtPredicateToBuilder(level, (NbtPredicate)nbt.orElseThrow(), state, builder);
        }
        if ((properties = predicate.properties()).isPresent()) {
            BlockPredicateTooltip.addStatePropertiesPredicateToBuilder(level, (StatePropertiesPredicate)properties.orElseThrow(), state, builder);
        }
    }

    public static String key(String key) {
        return PredicateTooltip.key("block.%s".formatted(key));
    }

    public static void addBlocksToBuilder(ClientLevel level, HolderSet<Block> blocks, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        PredicateTooltip.addRegisteredElementsToBuilder(level, BlockPredicateTooltip.key("matches"), Registries.BLOCK, blocks, Block::getName, state, builder);
    }

    public static void addDataComponentMatchersToBuilder(ClientLevel level, DataComponentMatchers components, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        DataComponentMatchersTooltip.addToBuilder(level, components, state, builder);
    }

    public static void addNbtPredicateToBuilder(ClientLevel level, NbtPredicate nbt, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        EntityPredicateTooltip.addNbtPredicateToBuilder(level, BlockPredicateTooltip.key("nbt"), nbt, state, builder);
    }

    public static void addStatePropertiesPredicateToBuilder(ClientLevel level, StatePropertiesPredicate properties, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        List matchers = properties.properties();
        if (matchers.isEmpty()) {
            builder.component(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(BlockPredicateTooltip.key("state_properties.any"), Styler::value, new Object[0])).build());
        } else {
            builder.component(CompositeContainerComponent.builder().space().cycle(propertyCycle -> {
                for (StatePropertiesPredicate.PropertyMatcher matcher : matchers) {
                    StatePropertiesPredicate.ValueMatcher selector0$temp;
                    CompositeContainerComponent.Builder propertyMatcherBuilder = CompositeContainerComponent.builder();
                    MutableComponent matcherName = Styler.property(Component.literal((String)StringUtils.capitalize((String)matcher.name())));
                    Objects.requireNonNull(matcher.valueMatcher());
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StatePropertiesPredicate.ExactMatcher.class, StatePropertiesPredicate.RangedMatcher.class}, (Object)selector0$temp, index$1)) {
                        case 0: {
                            StatePropertiesPredicate.ExactMatcher exact = (StatePropertiesPredicate.ExactMatcher)selector0$temp;
                            propertyMatcherBuilder.translate(BlockPredicateTooltip.key("state_property.exact"), Styler::condition, new Object[]{matcherName, Styler.value(Component.literal((String)StringUtils.capitalize((String)exact.value())))});
                            break;
                        }
                        case 1: {
                            StatePropertiesPredicate.RangedMatcher ranged = (StatePropertiesPredicate.RangedMatcher)selector0$temp;
                            String min = ranged.minValue().orElse(null);
                            String max = ranged.maxValue().orElse(null);
                            if (min == null && max == null) {
                                propertyMatcherBuilder.translate(BlockPredicateTooltip.key("state_property.any"), Styler::condition, new Object[]{matcherName});
                                break;
                            }
                            if (min != null && max != null) {
                                propertyMatcherBuilder.translate(BlockPredicateTooltip.key("state_property.between"), Styler::condition, new Object[]{matcherName, Styler.number(Component.literal((String)min)), Styler.number(Component.literal((String)max))});
                                break;
                            }
                            if (min != null) {
                                propertyMatcherBuilder.translate(BlockPredicateTooltip.key("state_property.at_least"), Styler::condition, new Object[]{matcherName, Styler.number(Component.literal((String)min))});
                                break;
                            }
                            propertyMatcherBuilder.translate(BlockPredicateTooltip.key("state_property.at_most"), Styler::condition, new Object[]{matcherName, Styler.number(Component.literal((String)max))});
                            break;
                        }
                        default: {
                            propertyMatcherBuilder.translate(BlockPredicateTooltip.key("state_property.any"), Styler::condition, new Object[]{matcherName});
                        }
                    }
                    propertyCycle.component(propertyMatcherBuilder.build());
                }
            }).build());
        }
    }
}

