/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.BlockPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.FluidPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;

public interface LocationPredicateTooltip {
    public static void addToBuilder(ClientLevel level, LocationPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Optional canSeeSky;
        Optional fluid;
        Optional block;
        Optional light;
        Optional smokey;
        Optional dimension;
        Optional structures;
        Optional biomes;
        Optional position = predicate.position();
        if (position.isPresent()) {
            LocationPredicateTooltip.addPositionPredicateToBuilder(level, (LocationPredicate.PositionPredicate)position.orElseThrow(), state, builder);
        }
        if ((biomes = predicate.biomes()).isPresent()) {
            LocationPredicateTooltip.addBiomesToBuilder(level, (HolderSet<Biome>)((HolderSet)biomes.orElseThrow()), state, builder);
        }
        if ((structures = predicate.structures()).isPresent()) {
            LocationPredicateTooltip.addStructuresToBuilder(level, (HolderSet<Structure>)((HolderSet)structures.orElseThrow()), state, builder);
        }
        if ((dimension = predicate.dimension()).isPresent()) {
            LocationPredicateTooltip.addDimensionToBuilder(level, (ResourceKey<Level>)((ResourceKey)dimension.orElseThrow()), state, builder);
        }
        if ((smokey = predicate.smokey()).isPresent()) {
            LocationPredicateTooltip.addSmokeyToBuilder(level, (Boolean)smokey.orElseThrow(), state, builder);
        }
        if ((light = predicate.light()).isPresent()) {
            LocationPredicateTooltip.addLightPredicateToBuilder(level, (LightPredicate)light.orElseThrow(), state, builder);
        }
        if ((block = predicate.block()).isPresent()) {
            LocationPredicateTooltip.addBlockPredicateToBuilder(level, (BlockPredicate)block.orElseThrow(), state, builder);
        }
        if ((fluid = predicate.fluid()).isPresent()) {
            LocationPredicateTooltip.addFluidPredicateToBuilder(level, (FluidPredicate)fluid.orElseThrow(), state, builder);
        }
        if ((canSeeSky = predicate.canSeeSky()).isPresent()) {
            LocationPredicateTooltip.addCanSeeSkyToBuilder(level, (Boolean)canSeeSky.orElseThrow(), state, builder);
        }
    }

    public static String key(String key) {
        return PredicateTooltip.key("location.%s".formatted(key));
    }

    public static void addPositionPredicateToBuilder(ClientLevel level, LocationPredicate.PositionPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        MinMaxBounds.Doubles x = predicate.x();
        MinMaxBounds.Doubles y = predicate.y();
        MinMaxBounds.Doubles z = predicate.z();
        CompositeContainerComponent.Builder positionBuilder = CompositeContainerComponent.builder().space();
        boolean useAnd = false;
        if (!x.isAny()) {
            PredicateTooltip.addMinMaxToBuilder(LocationPredicateTooltip.key("position.x"), useAnd, x.min().orElse(null), x.max().orElse(null), state, positionBuilder);
            useAnd = true;
        }
        if (!y.isAny()) {
            PredicateTooltip.addMinMaxToBuilder(LocationPredicateTooltip.key("position.y"), useAnd, y.min().orElse(null), y.max().orElse(null), state, positionBuilder);
            useAnd = true;
        }
        if (!z.isAny()) {
            PredicateTooltip.addMinMaxToBuilder(LocationPredicateTooltip.key("position.z"), useAnd, z.min().orElse(null), z.max().orElse(null), state, positionBuilder);
        }
        builder.component(positionBuilder.build());
    }

    public static void addBiomesToBuilder(ClientLevel level, HolderSet<Biome> biomes, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        PredicateTooltip.addRegisteredElementsToBuilder(level, LocationPredicateTooltip.key("biome"), Registries.BIOME, biomes, state, builder);
    }

    public static void addStructuresToBuilder(ClientLevel level, HolderSet<Structure> structures, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        PredicateTooltip.addRegisteredElementsToBuilder(level, LocationPredicateTooltip.key("structure"), Registries.STRUCTURE, structures, state, builder);
    }

    public static void addDimensionToBuilder(ClientLevel level, ResourceKey<Level> dimension, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        MutableComponent dimensionName = Styler.name(Component.literal((String)dimension.toString()));
        builder.component(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(LocationPredicateTooltip.key("dimension"), Styler::condition, new Object[0])).space().textComponent((Component)dimensionName).build());
    }

    public static void addSmokeyToBuilder(ClientLevel level, boolean smokey, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        builder.component(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(LocationPredicateTooltip.key("smokey.%s".formatted(smokey)), Styler::value, new Object[0])).build());
    }

    public static void addLightPredicateToBuilder(ClientLevel level, LightPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        MinMaxBounds.Ints composite = predicate.composite();
        if (composite.isAny()) {
            builder.space().translate(LocationPredicateTooltip.key("light.any"), Styler::value, new Object[0]);
        } else {
            PredicateTooltip.addMinMaxToBuilder(LocationPredicateTooltip.key("light.level"), false, composite.min().orElse(null), composite.max().orElse(null), state, builder);
        }
    }

    public static void addBlockPredicateToBuilder(ClientLevel level, BlockPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        BlockPredicateTooltip.addToBuilder(level, predicate, state, builder);
    }

    public static void addFluidPredicateToBuilder(ClientLevel level, FluidPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        FluidPredicateTooltip.addToBuilder(level, predicate, state, builder);
    }

    public static void addCanSeeSkyToBuilder(ClientLevel level, boolean canSeeSky, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        builder.component(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(LocationPredicateTooltip.key("can_see_sky.%s".formatted(canSeeSky)), Styler::value, new Object[0])).build());
    }
}

