/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.data;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.data.provider.BetterTrimsDimensionTypeTagProvider;
import com.bawnorton.bettertrims.data.provider.BetterTrimsEntityTypeTagProvider;
import com.bawnorton.bettertrims.data.provider.BetterTrimsRegistriesDataProvider;
import com.bawnorton.bettertrims.data.provider.BetterTrimsTrimEffectsRegistriesDataProvider;
import com.bawnorton.bettertrims.data.provider.TrimMaterialTagsProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.DetectedVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.util.InclusiveRange;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="bettertrims")
public final class BetterTrimsDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Server event) {
        DataGenerator gen = event.getGenerator();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PackOutput mainPack = gen.getPackOutput();
        gen.addProvider(true, (DataProvider)new TrimMaterialTagsProvider(mainPack, lookupProvider));
        gen.addProvider(true, (DataProvider)new BetterTrimsEntityTypeTagProvider(mainPack, lookupProvider));
        gen.addProvider(true, (DataProvider)new BetterTrimsDimensionTypeTagProvider(mainPack, lookupProvider));
        gen.addProvider(true, (DataProvider)BetterTrimsDataGen.getMetadataGenerator(mainPack, "${mod_description}"));
        DataGenerator.PackGenerator defaultPack = gen.getBuiltinDatapack(true, "bettertrims", BetterTrims.DEFAULT.getPath());
        defaultPack.addProvider(output -> new BetterTrimsRegistriesDataProvider(output, lookupProvider));
        defaultPack.addProvider(output -> BetterTrimsDataGen.getMetadataGenerator(output, "Default Better Trims Datapack"));
        DataGenerator.PackGenerator trimEffectsDatapack = gen.getBuiltinDatapack(true, "bettertrims", BetterTrims.TRIM_EFFECTS.getPath());
        trimEffectsDatapack.addProvider(output -> new BetterTrimsTrimEffectsRegistriesDataProvider(output, lookupProvider));
        trimEffectsDatapack.addProvider(output -> BetterTrimsDataGen.getMetadataGenerator(output, "Better Trims Trim Effects Datapack"));
    }

    private static PackMetadataGenerator getMetadataGenerator(PackOutput output, String description) {
        return new PackMetadataGenerator(output).add(PackMetadataSection.SERVER_TYPE, (Object)new PackMetadataSection((Component)Component.literal((String)description), (InclusiveRange)InclusiveRange.create((Comparable)DetectedVersion.BUILT_IN.packVersion(PackType.SERVER_DATA), (Comparable)DetectedVersion.BUILT_IN.packVersion(PackType.SERVER_DATA)).getOrThrow()));
    }
}

