/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.ability;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.ability.type.TrimToggleAbility;
import com.bawnorton.bettertrims.property.ability.type.TrimValueAbility;
import com.bawnorton.bettertrims.property.ability.type.misc.DamageImmunityAbility;
import com.bawnorton.bettertrims.property.ability.type.misc.PiglinSafeAbility;
import com.bawnorton.bettertrims.property.context.TrimContextParamSets;
import com.bawnorton.bettertrims.property.element.ConditionalElement;
import com.bawnorton.bettertrims.registry.BetterTrimsRegistries;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public interface TrimAbilityComponents {
    public static final Codec<DataComponentType<?>> COMPONENT_CODEC = Codec.lazyInitialized(() -> BetterTrimsRegistries.TRIM_ABILITY_COMPONENT_TYPE.byNameCodec());
    public static final Codec<DataComponentMap> CODEC = DataComponentMap.makeCodec(COMPONENT_CODEC);
    public static final Map<ResourceLocation, Component> TOOLTIPS = new HashMap<ResourceLocation, Component>();
    public static final DataComponentType<List<ConditionalElement<TrimValueAbility>>> INCOMING_DAMAGE = TrimAbilityComponents.register("incoming_damage", builder -> builder.persistent(ConditionalElement.ability(TrimValueAbility.CODEC, TrimContextParamSets.TRIM_DAMAGE).listOf()));
    public static final DataComponentType<List<ConditionalElement<DamageImmunityAbility>>> DAMAGE_IMMUNITY = TrimAbilityComponents.register("damage_immunity", builder -> builder.persistent(ConditionalElement.ability(DamageImmunityAbility.CODEC, TrimContextParamSets.TRIM_DAMAGE).listOf()));
    public static final DataComponentType<List<ConditionalElement<TrimValueAbility>>> DAMAGE = TrimAbilityComponents.register("damage", builder -> builder.persistent(ConditionalElement.ability(TrimValueAbility.CODEC, TrimContextParamSets.TRIM_DAMAGE).listOf()));
    public static final DataComponentType<List<ConditionalElement<TrimValueAbility>>> ARMOUR_EFFECTIVENESS = TrimAbilityComponents.register("armour_effectiveness", builder -> builder.persistent(ConditionalElement.ability(TrimValueAbility.CODEC, TrimContextParamSets.TRIM_DAMAGE).listOf()));
    public static final DataComponentType<List<ConditionalElement<TrimEntityAbility>>> POST_ATTACK = TrimAbilityComponents.register("post_attack", builder -> builder.persistent(ConditionalElement.ability(TrimEntityAbility.CODEC, TrimContextParamSets.TRIM_DAMAGE).listOf()));
    public static final DataComponentType<List<ConditionalElement<TrimEntityAbility>>> HIT_BLOCK = TrimAbilityComponents.register("hit_block", builder -> builder.persistent(ConditionalElement.ability(TrimEntityAbility.CODEC, TrimContextParamSets.HIT_BLOCK_WITH_HELD_ITEM).listOf()));
    public static final DataComponentType<List<ConditionalElement<TrimValueAbility>>> ITEM_DAMAGE = TrimAbilityComponents.register("item_damage", builder -> builder.persistent(ConditionalElement.ability(TrimValueAbility.CODEC, TrimContextParamSets.TRIM_EQUIPMENT).listOf()));
    public static final DataComponentType<List<ConditionalElement<TrimToggleAbility>>> EQUIPPED = TrimAbilityComponents.register("equipped", builder -> builder.persistent(ConditionalElement.ability(TrimToggleAbility.CODEC, TrimContextParamSets.TRIM_EQUIPMENT).listOf()));
    public static final DataComponentType<List<ConditionalElement<TrimEntityAbility>>> TICK = TrimAbilityComponents.register("tick", builder -> builder.persistent(ConditionalElement.ability(TrimEntityAbility.CODEC, TrimContextParamSets.TRIM_ENTITY).listOf()));
    public static final DataComponentType<List<ConditionalElement<TrimEntityAbility>>> SECOND = TrimAbilityComponents.register("second", builder -> builder.persistent(ConditionalElement.ability(TrimEntityAbility.CODEC, TrimContextParamSets.TRIM_ENTITY).listOf()));
    public static final DataComponentType<List<ConditionalElement<TrimEntityAbility>>> PROJECTILE_TICK = TrimAbilityComponents.register("projectile_tick", builder -> builder.persistent(ConditionalElement.ability(TrimEntityAbility.CODEC, TrimContextParamSets.TRIM_ENTITY).listOf()));
    public static final DataComponentType<List<ConditionalElement<TrimValueAbility>>> EXPERIENCE_GAINED = TrimAbilityComponents.register("experience_gained", builder -> builder.persistent(ConditionalElement.ability(TrimValueAbility.CODEC, TrimContextParamSets.TRIM_EQUIPMENT).listOf()));
    public static final DataComponentType<List<ConditionalElement<TrimValueAbility>>> TRADE_COST = TrimAbilityComponents.register("trade_cost", builder -> builder.persistent(ConditionalElement.ability(TrimValueAbility.CODEC, TrimContextParamSets.TRIM_EQUIPMENT).listOf()));
    public static final DataComponentType<List<ConditionalElement<PiglinSafeAbility>>> PIGLIN_SAFE = TrimAbilityComponents.register("piglin_safe", builder -> builder.persistent(ConditionalElement.ability(PiglinSafeAbility.CODEC, TrimContextParamSets.TRIM_ENTITY).listOf()));

    private static <T> DataComponentType<T> register(String name, UnaryOperator<DataComponentType.Builder<T>> operator) {
        ResourceLocation id = BetterTrims.rl(name);
        TOOLTIPS.put(id, (Component)Component.translatable((String)("bettertrims.tooltip.component." + name)));
        return (DataComponentType)Registry.register(BetterTrimsRegistries.TRIM_ABILITY_COMPONENT_TYPE, (ResourceLocation)id, (Object)((DataComponentType.Builder)operator.apply(DataComponentType.builder())).build());
    }

    public static DataComponentType<?> bootstrap(Registry<DataComponentType<?>> ignored) {
        return PIGLIN_SAFE;
    }
}

