package com.bawnorton.bettertrims.client.tooltip.component;

import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

import java.util.List;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5684;

public record StackedComponent(List<? extends class_5684> components,
                               int offset) implements class_5684 {
	public StackedComponent(List<? extends class_5684> components, int offset) {
		this.components = components.reversed();
		this.offset = offset;
	}

	@Override
		//? if >=1.21.8 {
	public int method_32661(class_327 font) {
		//?} else {
		/*public int getHeight() {
		 *///?}
		return 16;
	}

	@Override
	public int method_32664(class_327 font) {
		return Math.max(16, (16 - offset) + offset * components.size());
	}

	//? if >=1.21.8 {
	@Override
	public void method_32666(class_327 font, int x, int y, int width, int height, class_332 graphics) {
		if (components.isEmpty()) return;

		int currentOffset = components.size() - 1;
		for (class_5684 component : components) {
			component.method_32666(font, x + (offset * currentOffset), y, width, height, graphics);
			currentOffset--;
		}
	}

	@Override
	public void method_32665(class_332 guiGraphics, class_327 font, int x, int y) {
		if (components.isEmpty()) return;

		int currentOffset = components.size() - 1;
		for (class_5684 component : components) {
			component.method_32665(guiGraphics, font, x + (offset * currentOffset), y);
			currentOffset--;
		}
	}
	//?} else {

	/*@Override
	public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
		if (components.isEmpty()) return;

		int currentOffset = components.size() - 1;
		for (ClientTooltipComponent component : components) {
			component.renderImage(font, x + (offset * currentOffset), y, guiGraphics);
			currentOffset--;
		}
	}

	@Override
	public void renderText(Font font, int mouseX, int mouseY, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
		if (components.isEmpty()) return;

		int currentOffset = components.size() - 1;
		for (ClientTooltipComponent component : components) {
			component.renderText(font, mouseX + (offset * currentOffset), mouseY, matrix, bufferSource);
			currentOffset--;
		}
	}

	*///?}

	@Override
	public @NotNull String toString() {
		return "StackedComponent{%s}".formatted(components);
	}
}
