package com.bawnorton.bettertrims.mixin.property.ability.hit_block;

import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.runner.TrimEntityAbilityRunner;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

@Mixin(class_1890.class)
abstract class EnchantmentHelperMixin {
	@Inject(
			method = "onHitBlock",
			at = @At("TAIL")
	)
	private static void doOnHitBlockTrimAbilites(class_3218 level, class_1799 stack, class_1309 owner, class_1297 entity, class_1304 slot, class_243 pos, class_2680 state, Consumer<class_1792> onBreak, CallbackInfo ci) {
		if (owner == null) return;

		for (TrimProperty property : TrimProperties.getProperties(level)) {
			for (TrimEntityAbilityRunner<?> ability : property.getEntityAbilityRunners(TrimAbilityComponents.HIT_BLOCK)) {
				ability.runHitBlock(level, owner, entity, pos, state, stack);
			}
		}
	}
}
