/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class AppendableForwardingList<T>
extends AbstractList<T> {
    private final List<T> original;
    private final List<T> additionalElements;

    public AppendableForwardingList(List<T> original) {
        this.original = original;
        this.additionalElements = new ArrayList<T>();
    }

    @Override
    public T get(int index) {
        int originalSize = this.original.size();
        if (index < originalSize) {
            return this.original.get(index);
        }
        if (index - originalSize < this.additionalElements.size()) {
            return this.additionalElements.get(index - originalSize);
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
    }

    @Override
    public int size() {
        return this.original.size() + this.additionalElements.size();
    }

    @Override
    public void add(int index, T element) {
        if (index != this.size()) {
            throw new UnsupportedOperationException("Can only append at end");
        }
        this.additionalElements.add(element);
        ++this.modCount;
    }

    @Override
    public boolean add(T element) {
        this.additionalElements.add(element);
        ++this.modCount;
        return true;
    }

    @Override
    public T set(int index, T element) {
        int originalSize = this.original.size();
        if (index < originalSize) {
            throw new UnsupportedOperationException("Cannot modify original list");
        }
        return this.additionalElements.set(index - originalSize, element);
    }

    @Override
    public T remove(int index) {
        int originalSize = this.original.size();
        if (index < originalSize) {
            throw new UnsupportedOperationException("Cannot modify original list");
        }
        ++this.modCount;
        return this.additionalElements.remove(index - originalSize);
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.additionalElements.remove(o);
        if (removed) {
            ++this.modCount;
        }
        return removed;
    }

    @Override
    public void clear() {
        if (!this.additionalElements.isEmpty()) {
            this.additionalElements.clear();
            ++this.modCount;
        }
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        int totalSize = this.size();
        if (fromIndex < 0 || toIndex > totalSize || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex=" + fromIndex + ", toIndex=" + toIndex + ", size=" + totalSize);
        }
        int originalSize = this.original.size();
        ArrayList<T> result = new ArrayList<T>(toIndex - fromIndex);
        if (toIndex <= originalSize) {
            result.addAll(this.original.subList(fromIndex, toIndex));
        } else if (fromIndex >= originalSize) {
            result.addAll(this.additionalElements.subList(fromIndex - originalSize, toIndex - originalSize));
        } else {
            result.addAll(this.original.subList(fromIndex, originalSize));
            result.addAll(this.additionalElements.subList(0, toIndex - originalSize));
        }
        return result;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<T> origIt;
            private final Iterator<T> addIt;
            {
                this.origIt = AppendableForwardingList.this.original.iterator();
                this.addIt = AppendableForwardingList.this.additionalElements.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.origIt.hasNext() || this.addIt.hasNext();
            }

            @Override
            public T next() {
                if (this.origIt.hasNext()) {
                    return this.origIt.next();
                }
                if (this.addIt.hasNext()) {
                    return this.addIt.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removal via iterator not supported");
            }
        };
    }
}

