/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.EntityPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PlayerPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.LightningBoltPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.RaiderPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.client.multiplayer.ClientLevel;

public interface EntitySubPredicateTooltip {
    public static void addToBuilder(ClientLevel level, EntitySubPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        EntitySubPredicate entitySubPredicate = predicate;
        Objects.requireNonNull(entitySubPredicate);
        EntitySubPredicate entitySubPredicate2 = entitySubPredicate;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FishingHookPredicate.class, LightningBoltPredicate.class, PlayerPredicate.class, SlimePredicate.class, RaiderPredicate.class}, (Object)entitySubPredicate2, n)) {
            case 0: {
                FishingHookPredicate fishingHookPredicate = (FishingHookPredicate)entitySubPredicate2;
                EntitySubPredicateTooltip.addFishingHookPredicateToBuilder(level, fishingHookPredicate, state, builder);
                break;
            }
            case 1: {
                LightningBoltPredicate lightningBoltPredicate = (LightningBoltPredicate)entitySubPredicate2;
                EntitySubPredicateTooltip.addLightningBoltPredicateToBuilder(level, lightningBoltPredicate, state, builder);
                break;
            }
            case 2: {
                PlayerPredicate playerPredicate = (PlayerPredicate)entitySubPredicate2;
                EntitySubPredicateTooltip.addPlayerPredicateToBuilder(level, playerPredicate, state, builder);
                break;
            }
            case 3: {
                SlimePredicate slimePredicate = (SlimePredicate)entitySubPredicate2;
                EntitySubPredicateTooltip.addSlimePredicateToBuilder(level, slimePredicate, state, builder);
                break;
            }
            case 4: {
                RaiderPredicate raiderPredicate = (RaiderPredicate)entitySubPredicate2;
                EntitySubPredicateTooltip.addRaiderPredicateToBuilder(level, raiderPredicate, state, builder);
                break;
            }
            default: {
                builder.translate(EntitySubPredicateTooltip.key("unknown"), Styler::negative, new Object[0]);
            }
        }
    }

    public static String key(String key) {
        return PredicateTooltip.key("sub_entity.%s".formatted(key));
    }

    public static void addFishingHookPredicateToBuilder(ClientLevel level, FishingHookPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Optional inOpenWater = predicate.inOpenWater();
        if (inOpenWater.isPresent()) {
            builder.component(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate(EntitySubPredicateTooltip.key("fishing_hook.in_open_water.%s".formatted(inOpenWater.orElse(false) != false ? "true" : "false")), Styler::value, new Object[0])).build());
        }
    }

    public static void addLightningBoltPredicateToBuilder(ClientLevel level, LightningBoltPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        CompositeContainerComponent boltComponent;
        MinMaxBounds.Ints blocksSetOnFire;
        CompositeContainerComponent.Builder boltBuilder = CompositeContainerComponent.builder();
        boolean useAnd = false;
        Optional struck = predicate.entityStruck();
        if (struck.isPresent()) {
            CompositeContainerComponent.Builder entityBuilder = CompositeContainerComponent.builder();
            EntityPredicateTooltip.addToBuilder(level, (EntityPredicate)struck.orElseThrow(), state, entityBuilder);
            boltBuilder.component(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(EntitySubPredicateTooltip.key("lightning_bolt.entity_struck"), Styler::condition, new Object[0])).space().component(entityBuilder.build()).build());
            useAnd = true;
        }
        if (!(blocksSetOnFire = predicate.blocksSetOnFire()).isAny()) {
            PredicateTooltip.addMinMaxToBuilder(EntitySubPredicateTooltip.key("lightning_bolt.blocks_set_on_fire"), useAnd, blocksSetOnFire, state, boltBuilder);
        }
        if (!(boltComponent = boltBuilder.build()).isEmpty()) {
            builder.component(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(EntitySubPredicateTooltip.key("lightning_bolt.matches"), Styler::condition, new Object[0])).space().component(boltComponent).build());
        }
    }

    public static void addPlayerPredicateToBuilder(ClientLevel level, PlayerPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        PlayerPredicateTooltip.addToBuilder(level, predicate, state, builder);
    }

    public static void addSlimePredicateToBuilder(ClientLevel level, SlimePredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        MinMaxBounds.Ints size = predicate.size();
        if (!size.isAny()) {
            CompositeContainerComponent.Builder sizeBuilder = CompositeContainerComponent.builder().space();
            PredicateTooltip.addMinMaxToBuilder(EntitySubPredicateTooltip.key("slime.size"), false, size, state, sizeBuilder);
            builder.component(sizeBuilder.build());
        }
    }

    public static void addRaiderPredicateToBuilder(ClientLevel level, RaiderPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        boolean hasRaid = predicate.hasRaid();
        boolean captain = predicate.isCaptain();
        if (hasRaid || captain) {
            Object key = "raider.";
            if (hasRaid) {
                key = (String)key + "in_raid";
            }
            if (captain) {
                if (hasRaid) {
                    key = (String)key + "_and_";
                }
                key = (String)key + "is_captain";
            }
            builder.component(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(EntitySubPredicateTooltip.key((String)key), Styler::value, new Object[0])).build());
        }
    }
}

