/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.partial;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.partial.FireworkPredicateAdder;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.partial.PartialAdder;
import com.bawnorton.bettertrims.client.tooltip.util.Formatter;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.util.Optional;
import net.minecraft.advancements.critereon.CollectionPredicate;
import net.minecraft.advancements.critereon.ItemFireworksPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.client.multiplayer.ClientLevel;

public final class FireworksPredicatePartialAdder
implements PartialAdder<ItemFireworksPredicate> {
    private final FireworkPredicateAdder predicateAdder = new FireworkPredicateAdder();

    @Override
    public void addToBuilder(ClientLevel level, ItemFireworksPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        MinMaxBounds.Ints flightDuration = predicate.flightDuration();
        Optional explosions = predicate.explosions();
        if (!flightDuration.isAny()) {
            builder.space().translate(this.key("fireworks.flight_duration"), Styler::condition, new Object[0]);
            PredicateTooltip.addMinMaxToBuilder(this.key("fireworks.flight_duration"), false, flightDuration, v -> Formatter.decimal(v).append("s"), state, builder);
            builder.space().translate("bettertrims.tooltip.and", Styler::condition, new Object[0]);
        } else {
            builder.space().translate(this.key("fireworks.flight_duration.any"), Styler::condition, new Object[0]);
        }
        builder.cycle(cycleBuilder -> {
            CollectionPredicate fireworkCollection = (CollectionPredicate)explosions.orElseThrow();
            CompositeContainerComponent.Builder fireworkBuilder = CompositeContainerComponent.builder();
            this.addCollectionToBuilder(level, fireworkCollection, "fireworks", this.predicateAdder, state, fireworkBuilder);
            cycleBuilder.component(fireworkBuilder.build());
        });
    }
}

