/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.partial;

import com.bawnorton.bettertrims.client.mixin.accessor.PotionAccessor;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.partial.PartialAdder;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.ItemPotionsPredicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import org.apache.commons.lang3.StringUtils;

public final class PotionsPredicatePartialAdder
implements PartialAdder<ItemPotionsPredicate> {
    @Override
    public void addToBuilder(ClientLevel level, ItemPotionsPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        HolderSet potions = predicate.potions();
        if (potions.size() == 0) {
            builder.translate(this.key("potions.any"), Styler::condition, new Object[0]);
        } else {
            PredicateTooltip.addRegisteredElementsToBuilder(level, this.key("potions.matches"), Registries.POTION, potions, (potion, appender) -> {
                List effects = potion.getEffects();
                if (effects.isEmpty()) {
                    return Component.literal((String)StringUtils.capitalize((String)((PotionAccessor)potions).bettertrims$name()));
                }
                MobEffectInstance effect = (MobEffectInstance)effects.getFirst();
                ChatFormatting formatting = ((MobEffect)effect.getEffect().value()).getCategory().getTooltipFormatting();
                MutableComponent description = Component.translatable((String)((MobEffect)effect.getEffect().value()).getDescriptionId()).withStyle(formatting);
                appender.textComponent((Component)(effect.getAmplifier() > 0 ? Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{description, Component.translatable((String)("potion.potency." + String.valueOf(level)))}) : description));
                for (int i = 1; i < effects.size(); ++i) {
                    effect = (MobEffectInstance)effects.get(i);
                    description = Component.translatable((String)((MobEffect)effect.getEffect().value()).getDescriptionId());
                    appender.literal(", ", Styler::condition).textComponent((Component)(effect.getAmplifier() > 0 ? Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{description, Component.translatable((String)("potion.potency." + String.valueOf(level)))}) : description));
                }
                return Component.literal((String)"");
            }, state, builder);
        }
    }
}

