/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.mixin.property.ability.hit_block;

import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.runner.TrimEntityAbilityRunner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ThrownPotion.class})
abstract class ThrownPotionMixin
extends ThrowableItemProjectile {
    ThrownPotionMixin(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"onHitBlock"}, at={@At(value="HEAD")})
    private void triggerTrimOnHit(BlockHitResult result, CallbackInfo ci) {
        Entity entity = this.getEffectSource();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity wearer = (LivingEntity)entity;
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        for (TrimProperty property : TrimProperties.getProperties((Level)level2)) {
            for (TrimEntityAbilityRunner<?> ability : property.getEntityAbilityRunners(TrimAbilityComponents.HIT_BLOCK)) {
                Vec3 pos = result.getLocation();
                BlockState state = level2.getBlockState(BlockPos.containing((Position)pos));
                ability.runHitBlock(level2, wearer, (Entity)wearer, pos, state, this.getItem());
            }
        }
    }
}

