/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.data.BetterTrimsDimensionTypeTags;
import com.bawnorton.bettertrims.data.BetterTrimsEntityTypeTags;
import com.bawnorton.bettertrims.data.TrimMaterialTags;
import com.bawnorton.bettertrims.property.AllOf;
import com.bawnorton.bettertrims.property.Matcher;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.type.TrimValueAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.ApplyMobEffectAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.PlaySoundAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.SpawnParticlesAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.SummonEntityAbility;
import com.bawnorton.bettertrims.property.ability.type.misc.DamageImmunityAbility;
import com.bawnorton.bettertrims.property.ability.type.misc.PiglinSafeAbility;
import com.bawnorton.bettertrims.property.ability.type.toggle.AttributeAbility;
import com.bawnorton.bettertrims.property.ability.type.toggle.ToggleMobEffectAbility;
import com.bawnorton.bettertrims.property.condition.DimensionCheck;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.bawnorton.bettertrims.property.item.TrimItemPropertyComponents;
import com.bawnorton.bettertrims.property.item.type.DamageImmunityItemProperty;
import com.bawnorton.bettertrims.registry.BetterTrimsAttributes;
import com.bawnorton.bettertrims.registry.BetterTrimsRegistries;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.ItemTrimPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MovementPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.predicates.TimeCheck;
import net.minecraft.world.level.storage.loot.predicates.WeatherCheck;
import org.jetbrains.annotations.NotNull;

public interface TrimProperties {
    public static final ResourceKey<TrimProperty> CONDUCTIVE = TrimProperties.key("conductive");
    public static final ResourceKey<TrimProperty> CHARGED = TrimProperties.key("charged");
    public static final ResourceKey<TrimProperty> FIREPROOF = TrimProperties.key("fireproof");
    public static final ResourceKey<TrimProperty> IMPROVED_TRADING = TrimProperties.key("improved_trading");
    public static final ResourceKey<TrimProperty> INCREASE_EXPERIENCE_GAIN = TrimProperties.key("increase_experience_gain");
    public static final ResourceKey<TrimProperty> INCREASE_MINING_SPEED = TrimProperties.key("increase_mining_speed");
    public static final ResourceKey<TrimProperty> INCREASE_MOVEMENT_SPEED = TrimProperties.key("increase_movement_speed");
    public static final ResourceKey<TrimProperty> LUNAR_BONUSES = TrimProperties.key("lunar_bonuses");
    public static final ResourceKey<TrimProperty> TOUGHER = TrimProperties.key("tougher");
    public static final ResourceKey<TrimProperty> RESILIENT = TrimProperties.key("resilient");
    public static final ResourceKey<TrimProperty> RESONANT = TrimProperties.key("resonant");
    public static final ResourceKey<TrimProperty> SHADOWY = TrimProperties.key("shadowy");
    public static final ResourceKey<TrimProperty> SOLAR_BONUSES = TrimProperties.key("solar_bonuses");
    public static final ResourceKey<TrimProperty> WEARING_GOLD = TrimProperties.key("wearing_gold");
    public static final ResourceKey<TrimProperty> BOLT = TrimProperties.key("bolt");
    public static final ResourceKey<TrimProperty> COAST = TrimProperties.key("coast");
    public static final ResourceKey<TrimProperty> DUNE = TrimProperties.key("dune");
    public static final ResourceKey<TrimProperty> EYE = TrimProperties.key("eye");
    public static final ResourceKey<TrimProperty> FLOW = TrimProperties.key("flow");
    public static final ResourceKey<TrimProperty> HOST = TrimProperties.key("host");
    public static final ResourceKey<TrimProperty> RAISER = TrimProperties.key("raiser");
    public static final ResourceKey<TrimProperty> RIB = TrimProperties.key("rib");
    public static final ResourceKey<TrimProperty> SENTRY = TrimProperties.key("sentry");
    public static final ResourceKey<TrimProperty> SHAPER = TrimProperties.key("shaper");
    public static final ResourceKey<TrimProperty> SILENCE = TrimProperties.key("silence");
    public static final ResourceKey<TrimProperty> SNOUT = TrimProperties.key("snout");
    public static final ResourceKey<TrimProperty> SPIRE = TrimProperties.key("spire");
    public static final ResourceKey<TrimProperty> TIDE = TrimProperties.key("tide");
    public static final ResourceKey<TrimProperty> VEX = TrimProperties.key("vex");
    public static final ResourceKey<TrimProperty> WARD = TrimProperties.key("ward");
    public static final ResourceKey<TrimProperty> WAYFINDER = TrimProperties.key("wayfinder");
    public static final ResourceKey<TrimProperty> WILD = TrimProperties.key("wild");

    public static void bootstrap(BootstrapContext<TrimProperty> context) {
        HolderGetter materialGetter = context.lookup(Registries.TRIM_MATERIAL);
        HolderGetter entityTypeGetter = context.lookup(Registries.ENTITY_TYPE);
        HolderGetter enchantmentGetter = context.lookup(Registries.ENCHANTMENT);
        HolderGetter dimensionGetter = context.lookup(Registries.DIMENSION_TYPE);
        HolderGetter soundEventGetter = context.lookup(Registries.SOUND_EVENT);
        TrimProperties.register(context, SHADOWY, TrimProperty.builder(TrimProperties.getMaterialMatcher((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.RESIN)).ability(TrimAbilityComponents.TICK, new SpawnParticlesAbility((ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER, SpawnParticlesEffect.inBoundingBox(), SpawnParticlesEffect.inBoundingBox(), SpawnParticlesEffect.movementScaled((float)-0.2f), SpawnParticlesEffect.fixedVelocity((FloatProvider)ConstantFloat.of((float)0.1f)), (FloatProvider)ConstantFloat.of((float)0.5f)), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().moving(MovementPredicate.speed((MinMaxBounds.Doubles)MinMaxBounds.Doubles.atLeast((double)0.1))))).ability(TrimAbilityComponents.TICK, new SpawnParticlesAbility((ParticleOptions)ParticleTypes.ASH, SpawnParticlesEffect.inBoundingBox(), SpawnParticlesEffect.inBoundingBox(), SpawnParticlesEffect.fixedVelocity((FloatProvider)ConstantFloat.of((float)0.0f)), SpawnParticlesEffect.fixedVelocity((FloatProvider)ConstantFloat.of((float)0.0f)), (FloatProvider)ConstantFloat.of((float)0.0f)), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().moving(MovementPredicate.speed((MinMaxBounds.Doubles)MinMaxBounds.Doubles.atMost((double)0.1))))).ability(TrimAbilityComponents.EQUIPPED, new AttributeAbility(BetterTrims.rl("trim_true_invisibility"), BetterTrimsAttributes.TRUE_INVISIBILITY, CountBasedValue.constant(1.0f), AttributeModifier.Operation.ADD_VALUE), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().moving(MovementPredicate.speed((MinMaxBounds.Doubles)MinMaxBounds.Doubles.atMost((double)0.1))))).ability(TrimAbilityComponents.DAMAGE, TrimValueAbility.multiply(CountBasedValue.linear(1.25f, 0.25f)), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().moving(MovementPredicate.speed((MinMaxBounds.Doubles)MinMaxBounds.Doubles.atMost((double)0.1))))).build());
        TrimProperties.register(context, WEARING_GOLD, TrimProperty.builder(TrimProperties.getMaterialMatcher((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.GOLD)).ability(TrimAbilityComponents.PIGLIN_SAFE, PiglinSafeAbility.INSTANCE).build());
        TrimProperties.register(context, INCREASE_MINING_SPEED, TrimProperty.builder(TrimProperties.getMaterialMatcher((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.IRON)).ability(TrimAbilityComponents.EQUIPPED, new AttributeAbility(BetterTrims.rl("trim_mining_speed"), (Holder<Attribute>)Attributes.MINING_EFFICIENCY, CountBasedValue.countSquared(1.0f), AttributeModifier.Operation.ADD_VALUE)).ability(TrimAbilityComponents.EQUIPPED, new ToggleMobEffectAbility((Holder<MobEffect>)MobEffects.DIG_SPEED, CountBasedValue.constant(1.0f)), TrimProperties.wearingFullSet((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.IRON)).build());
        TrimProperties.register(context, RESILIENT, TrimProperty.builder(TrimProperties.getMaterialMatcher((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.DIAMOND)).ability(TrimAbilityComponents.INCOMING_DAMAGE, TrimValueAbility.multiply(CountBasedValue.linear(0.95f, -0.05f)), DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.isNot((TagKey)DamageTypeTags.BYPASSES_RESISTANCE)))).ability(TrimAbilityComponents.ITEM_DAMAGE, TrimValueAbility.removeBinomial(CountBasedValue.fraction(CountBasedValue.linear(1.0f), CountBasedValue.linear(4.0f, 1.0f))), MatchTool.toolMatches((ItemPredicate.Builder)TrimProperties.itemMaterialPredicate((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.DIAMOND))).build());
        TrimProperties.register(context, RESONANT, TrimProperty.builder(TrimProperties.getMaterialMatcher((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.AMETHYST)).ability(TrimAbilityComponents.POST_ATTACK, new PlaySoundAbility((Holder<SoundEvent>)Holder.direct((Object)SoundEvents.AMETHYST_BLOCK_RESONATE), (FloatProvider)UniformFloat.of((float)0.8f, (float)1.2f), (FloatProvider)UniformFloat.of((float)0.8f, (float)1.2f))).ability(TrimAbilityComponents.HIT_BLOCK, new PlaySoundAbility((Holder<SoundEvent>)Holder.direct((Object)SoundEvents.AMETHYST_BLOCK_RESONATE), (FloatProvider)UniformFloat.of((float)0.8f, (float)1.2f), (FloatProvider)UniformFloat.of((float)0.8f, (float)1.2f))).ability(TrimAbilityComponents.INCOMING_DAMAGE, TrimValueAbility.multiply(CountBasedValue.clamped(CountBasedValue.linear(0.75f, -0.25f), 0.0f, 1.0f)), LootItemRandomChanceCondition.randomChance((float)0.05f)).ability(TrimAbilityComponents.DAMAGE, TrimValueAbility.multiply(CountBasedValue.linear(5.0f)), LootItemRandomChanceCondition.randomChance((float)0.05f)).build());
        TrimProperties.register(context, TOUGHER, TrimProperty.builder(TrimProperties.getMaterialMatcher((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.NETHERITE)).ability(TrimAbilityComponents.EQUIPPED, AllOf.toggleAbilities(new AttributeAbility(BetterTrims.rl("trim_armour_toughness"), (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, CountBasedValue.linear(1.0f), AttributeModifier.Operation.ADD_VALUE), new AttributeAbility(BetterTrims.rl("trim_armour"), (Holder<Attribute>)Attributes.ARMOR, CountBasedValue.linear(2.0f), AttributeModifier.Operation.ADD_VALUE))).ability(TrimAbilityComponents.ITEM_DAMAGE, TrimValueAbility.removeBinomial(CountBasedValue.fraction(CountBasedValue.linear(1.0f), CountBasedValue.linear(2.0f, 1.0f))), MatchTool.toolMatches((ItemPredicate.Builder)TrimProperties.itemMaterialPredicate((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.NETHERITE))).build());
        TrimProperties.register(context, FIREPROOF, TrimProperty.builder(TrimProperties.getMaterialMatcher((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.NETHERITE)).ability(TrimAbilityComponents.EQUIPPED, new ToggleMobEffectAbility((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE, CountBasedValue.constant(0.0f))).itemProperty(TrimItemPropertyComponents.DAMAGE_IMMUNITY, DamageImmunityItemProperty.INSTANCE, DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_FIRE)).tag(TagPredicate.isNot((TagKey)DamageTypeTags.BYPASSES_INVULNERABILITY)))).build());
        TrimProperties.register(context, INCREASE_EXPERIENCE_GAIN, TrimProperty.builder(TrimProperties.getMaterialMatcher((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.QUARTZ)).ability(TrimAbilityComponents.EXPERIENCE_GAINED, TrimValueAbility.multiply(CountBasedValue.linear(1.25f, 0.25f))).build());
        TrimProperties.register(context, INCREASE_MOVEMENT_SPEED, TrimProperty.builder(TrimProperties.getMaterialMatcher((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.REDSTONE)).ability(TrimAbilityComponents.EQUIPPED, new AttributeAbility(BetterTrims.rl("trim_movement_speed"), (Holder<Attribute>)Attributes.MOVEMENT_SPEED, CountBasedValue.linear(0.12f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)).build());
        TrimProperties.register(context, CONDUCTIVE, TrimProperty.builder(TrimProperties.getMaterialMatcher((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.COPPER)).ability(TrimAbilityComponents.DAMAGE_IMMUNITY, DamageImmunityAbility.INSTANCE, DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_LIGHTNING)).tag(TagPredicate.isNot((TagKey)DamageTypeTags.BYPASSES_INVULNERABILITY)))).itemProperty(TrimItemPropertyComponents.DAMAGE_IMMUNITY, DamageImmunityItemProperty.INSTANCE, DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_LIGHTNING)).tag(TagPredicate.isNot((TagKey)DamageTypeTags.BYPASSES_INVULNERABILITY)))).build());
        TrimProperties.register(context, CHARGED, TrimProperty.builder(TrimProperties.getMaterialMatcher((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.COPPER)).ability(TrimAbilityComponents.PROJECTILE_TICK, new SpawnParticlesAbility((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, SpawnParticlesEffect.offsetFromEntityPosition((float)0.0f), SpawnParticlesEffect.offsetFromEntityPosition((float)0.0f), SpawnParticlesEffect.movementScaled((float)-0.5f), SpawnParticlesEffect.movementScaled((float)-0.5f), (FloatProvider)ConstantFloat.of((float)1.0f)), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().entityType(TrimProperties.getEntityTypePredicate(entityTypeGetter, BetterTrimsEntityTypeTags.CONDUCTIVE_PROJECTILES)))).ability(TrimAbilityComponents.DAMAGE, TrimValueAbility.add(CountBasedValue.linear(0.5f)), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.DIRECT_ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().entityType(TrimProperties.getEntityTypePredicate(entityTypeGetter, BetterTrimsEntityTypeTags.CONDUCTIVE_PROJECTILES)))).ability(TrimAbilityComponents.POST_ATTACK, AllOf.entityAbilities(new SummonEntityAbility(EntityType.LIGHTNING_BOLT), new PlaySoundAbility((Holder<SoundEvent>)SoundEvents.TRIDENT_THUNDER, (FloatProvider)ConstantFloat.of((float)5.0f), (FloatProvider)ConstantFloat.of((float)1.0f))), (LootItemCondition.Builder)AllOfCondition.allOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{WeatherCheck.weather().setThundering(true), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().located(LocationPredicate.Builder.location().setCanSeeSky(true))), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.DIRECT_ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().entityType(TrimProperties.getEntityTypePredicate(entityTypeGetter, BetterTrimsEntityTypeTags.CONDUCTIVE_PROJECTILES))), InvertedLootItemCondition.invert((LootItemCondition.Builder)MatchTool.toolMatches((ItemPredicate.Builder)TrimProperties.itemEnchantedPredicate((HolderGetter<Enchantment>)enchantmentGetter, (ResourceKey<Enchantment>)Enchantments.CHANNELING)))})).ability(TrimAbilityComponents.HIT_BLOCK, AllOf.entityAbilities(new SummonEntityAbility(EntityType.LIGHTNING_BOLT), new PlaySoundAbility((Holder<SoundEvent>)SoundEvents.TRIDENT_THUNDER, (FloatProvider)ConstantFloat.of((float)5.0f), (FloatProvider)ConstantFloat.of((float)1.0f))), (LootItemCondition.Builder)AllOfCondition.allOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{WeatherCheck.weather().setThundering(true), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().entityType(TrimProperties.getEntityTypePredicate(entityTypeGetter, BetterTrimsEntityTypeTags.CONDUCTIVE_PROJECTILES))), LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)Blocks.LIGHTNING_ROD), InvertedLootItemCondition.invert((LootItemCondition.Builder)MatchTool.toolMatches((ItemPredicate.Builder)TrimProperties.itemEnchantedPredicate((HolderGetter<Enchantment>)enchantmentGetter, (ResourceKey<Enchantment>)Enchantments.CHANNELING)))})).build());
        TrimProperties.register(context, SOLAR_BONUSES, TrimProperty.builder(TrimProperties.getMaterialMatcher((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.GOLD)).ability(TrimAbilityComponents.EQUIPPED, AllOf.toggleAbilities(new AttributeAbility(BetterTrims.rl("trim_solar_bonus_attack_damage"), (Holder<Attribute>)Attributes.ATTACK_DAMAGE, CountBasedValue.linear(1.0f), AttributeModifier.Operation.ADD_VALUE), new AttributeAbility(BetterTrims.rl("trim_solar_bonus_movement_speed"), (Holder<Attribute>)Attributes.MOVEMENT_SPEED, CountBasedValue.linear(0.07f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), new AttributeAbility(BetterTrims.rl("trim_solar_bonus_armour"), (Holder<Attribute>)Attributes.ARMOR, CountBasedValue.linear(1.0f), AttributeModifier.Operation.ADD_VALUE), new AttributeAbility(BetterTrims.rl("trim_solar_bonus_attack_speed"), (Holder<Attribute>)Attributes.ATTACK_SPEED, CountBasedValue.linear(0.5f), AttributeModifier.Operation.ADD_VALUE)), (LootItemCondition.Builder)AllOfCondition.allOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{TimeCheck.time((IntRange)IntRange.upperBound((int)13000)).setPeriod(24000L), DimensionCheck.of((HolderSet<DimensionType>)dimensionGetter.getOrThrow(BetterTrimsDimensionTypeTags.HAS_SUN))})).build());
        TrimProperties.register(context, LUNAR_BONUSES, TrimProperty.builder(TrimProperties.getMaterialMatcher((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.SILVER)).ability(TrimAbilityComponents.EQUIPPED, AllOf.toggleAbilities(new AttributeAbility(BetterTrims.rl("trim_lunar_bonus_attack_damage"), (Holder<Attribute>)Attributes.ATTACK_DAMAGE, CountBasedValue.linear(1.0f), AttributeModifier.Operation.ADD_VALUE), new AttributeAbility(BetterTrims.rl("trim_lunar_bonus_movement_speed"), (Holder<Attribute>)Attributes.MOVEMENT_SPEED, CountBasedValue.linear(0.07f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), new AttributeAbility(BetterTrims.rl("trim_lunar_bonus_armour"), (Holder<Attribute>)Attributes.ARMOR, CountBasedValue.linear(1.0f), AttributeModifier.Operation.ADD_VALUE), new AttributeAbility(BetterTrims.rl("trim_lunar_bonus_attack_speed"), (Holder<Attribute>)Attributes.ATTACK_SPEED, CountBasedValue.linear(0.05f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)), (LootItemCondition.Builder)AllOfCondition.allOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{TimeCheck.time((IntRange)IntRange.lowerBound((int)13000)).setPeriod(24000L), DimensionCheck.of((HolderSet<DimensionType>)dimensionGetter.getOrThrow(BetterTrimsDimensionTypeTags.HAS_MOON))})).ability(TrimAbilityComponents.EQUIPPED, new ToggleMobEffectAbility((Holder<MobEffect>)MobEffects.NIGHT_VISION, CountBasedValue.constant(0.0f)), TrimProperties.wearingInSlot((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.SILVER, EquipmentSlot.HEAD)).build());
        TrimProperties.register(context, IMPROVED_TRADING, TrimProperty.builder(TrimProperties.getMaterialMatcher((HolderGetter<TrimMaterial>)materialGetter, TrimMaterialTags.EMERALD)).ability(TrimAbilityComponents.TRADE_COST, TrimValueAbility.multiply(CountBasedValue.linear(0.9f, -0.1f))).build());
    }

    public static void bootstrapTrimEffects(BootstrapContext<TrimProperty> context) {
        TrimProperties.registerTrimEffect(context, BOLT, (ResourceKey<TrimPattern>)TrimPatterns.BOLT, (Holder<MobEffect>)MobEffects.DOLPHINS_GRACE);
        TrimProperties.registerTrimEffect(context, COAST, (ResourceKey<TrimPattern>)TrimPatterns.COAST, (Holder<MobEffect>)MobEffects.WATER_BREATHING);
        TrimProperties.registerTrimEffect(context, DUNE, (ResourceKey<TrimPattern>)TrimPatterns.DUNE, (Holder<MobEffect>)MobEffects.MOVEMENT_SPEED);
        TrimProperties.registerTrimEffect(context, EYE, (ResourceKey<TrimPattern>)TrimPatterns.EYE, (Holder<MobEffect>)MobEffects.REGENERATION);
        TrimProperties.registerTrimEffect(context, FLOW, (ResourceKey<TrimPattern>)TrimPatterns.FLOW, (Holder<MobEffect>)MobEffects.JUMP);
        TrimProperties.registerTrimEffect(context, HOST, (ResourceKey<TrimPattern>)TrimPatterns.HOST, (Holder<MobEffect>)MobEffects.GLOWING);
        TrimProperties.registerTrimEffect(context, RAISER, (ResourceKey<TrimPattern>)TrimPatterns.RAISER, (Holder<MobEffect>)MobEffects.SATURATION);
        TrimProperties.registerTrimEffect(context, RIB, (ResourceKey<TrimPattern>)TrimPatterns.RIB, (Holder<MobEffect>)MobEffects.DIG_SPEED);
        TrimProperties.registerTrimEffect(context, SENTRY, (ResourceKey<TrimPattern>)TrimPatterns.SENTRY, (Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE);
        TrimProperties.registerTrimEffect(context, SHAPER, (ResourceKey<TrimPattern>)TrimPatterns.SHAPER, (Holder<MobEffect>)MobEffects.LUCK);
        TrimProperties.registerTrimEffect(context, SILENCE, (ResourceKey<TrimPattern>)TrimPatterns.SILENCE, (Holder<MobEffect>)MobEffects.HEALTH_BOOST);
        TrimProperties.registerTrimEffect(context, SNOUT, (ResourceKey<TrimPattern>)TrimPatterns.SNOUT, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE);
        TrimProperties.registerTrimEffect(context, SPIRE, (ResourceKey<TrimPattern>)TrimPatterns.SPIRE, (Holder<MobEffect>)MobEffects.DAMAGE_BOOST);
        TrimProperties.registerTrimEffect(context, TIDE, (ResourceKey<TrimPattern>)TrimPatterns.TIDE, (Holder<MobEffect>)MobEffects.CONDUIT_POWER);
        TrimProperties.registerTrimEffect(context, VEX, (ResourceKey<TrimPattern>)TrimPatterns.VEX, (Holder<MobEffect>)MobEffects.INVISIBILITY);
        TrimProperties.registerTrimEffect(context, WAYFINDER, (ResourceKey<TrimPattern>)TrimPatterns.WAYFINDER, (Holder<MobEffect>)MobEffects.SLOW_FALLING);
        TrimProperties.registerTrimEffect(context, WILD, (ResourceKey<TrimPattern>)TrimPatterns.WILD, (Holder<MobEffect>)MobEffects.HERO_OF_THE_VILLAGE);
        TrimProperties.register(context, WARD, TrimProperty.builder(Matcher.forPattern((HolderSet<TrimPattern>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.TRIM_PATTERN).getOrThrow(TrimPatterns.WARD)}), 2)).ability(TrimAbilityComponents.SECOND, new ApplyMobEffectAbility((Holder<MobEffect>)MobEffects.ABSORPTION, CountBasedValue.lookup(List.of(Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)), CountBasedValue.constant(0.0f)), CountBasedValue.constant(16.0f)), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)new EntityPredicate.Builder().periodicTick(300))).build());
    }

    private static void registerTrimEffect(BootstrapContext<TrimProperty> context, ResourceKey<TrimProperty> key, ResourceKey<TrimPattern> pattern, Holder<MobEffect> effect) {
        TrimProperties.register(context, key, TrimProperty.builder(Matcher.forPattern((HolderSet<TrimPattern>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.TRIM_PATTERN).getOrThrow(pattern)}), 2)).ability(TrimAbilityComponents.SECOND, new ApplyMobEffectAbility(effect, CountBasedValue.lookup(List.of(Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)), CountBasedValue.constant(0.0f)), CountBasedValue.constant(9.0f))).build());
    }

    private static EntityTypePredicate getEntityTypePredicate(HolderGetter<EntityType<?>> entityTypeGetter, TagKey<EntityType<?>> tag) {
        return EntityTypePredicate.of(tag);
    }

    private static LootItemCondition.Builder wearingInSlot(HolderGetter<TrimMaterial> materialGetter, TagKey<TrimMaterial> material, EquipmentSlot slot) {
        return LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().equipment(TrimProperties.addSlot(EntityEquipmentPredicate.Builder.equipment(), materialGetter, material, slot)));
    }

    private static LootItemCondition.Builder wearingFullSet(HolderGetter<TrimMaterial> materialGetter, TagKey<TrimMaterial> material) {
        return LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().equipment(TrimProperties.fullSetMaterialPredicate(materialGetter, material)));
    }

    private static EntityEquipmentPredicate.Builder fullSetMaterialPredicate(HolderGetter<TrimMaterial> materialGetter, TagKey<TrimMaterial> material) {
        EntityEquipmentPredicate.Builder builder = EntityEquipmentPredicate.Builder.equipment();
        for (EquipmentSlot slot : List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET)) {
            TrimProperties.addSlot(builder, materialGetter, material, slot);
        }
        return builder;
    }

    private static EntityEquipmentPredicate.Builder addSlot(EntityEquipmentPredicate.Builder builder, HolderGetter<TrimMaterial> materialGetter, TagKey<TrimMaterial> material, EquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                builder.head(TrimProperties.itemMaterialPredicate(materialGetter, material));
                break;
            }
            case CHEST: {
                builder.chest(TrimProperties.itemMaterialPredicate(materialGetter, material));
                break;
            }
            case LEGS: {
                builder.legs(TrimProperties.itemMaterialPredicate(materialGetter, material));
                break;
            }
            case FEET: {
                builder.feet(TrimProperties.itemMaterialPredicate(materialGetter, material));
                break;
            }
            case BODY: {
                builder.body(TrimProperties.itemMaterialPredicate(materialGetter, material));
                break;
            }
            case MAINHAND: {
                builder.mainhand(TrimProperties.itemMaterialPredicate(materialGetter, material));
                break;
            }
            case OFFHAND: {
                builder.offhand(TrimProperties.itemMaterialPredicate(materialGetter, material));
                break;
            }
        }
        return builder;
    }

    private static ItemPredicate.Builder itemMaterialPredicate(HolderGetter<TrimMaterial> materialGetter, TagKey<TrimMaterial> material) {
        return ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ARMOR_TRIM, (ItemSubPredicate)new ItemTrimPredicate(Optional.of(materialGetter.getOrThrow(material)), Optional.empty()));
    }

    private static ItemPredicate.Builder itemEnchantedPredicate(HolderGetter<Enchantment> enchantmentGetter, ResourceKey<Enchantment> enchantment) {
        return ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)enchantmentGetter.getOrThrow(enchantment), MinMaxBounds.Ints.ANY))));
    }

    @NotNull
    private static Matcher getMaterialMatcher(HolderGetter<TrimMaterial> materialGetter, TagKey<TrimMaterial> material) {
        return Matcher.forMaterial((HolderSet<TrimMaterial>)materialGetter.getOrThrow(material), 1);
    }

    public static Iterable<TrimProperty> getProperties(Level level) {
        return level.registryAccess().lookupOrThrow(BetterTrimsRegistries.Keys.TRIM_PROPERTIES).listElements().map(Holder.Reference::value)::iterator;
    }

    private static void register(BootstrapContext<TrimProperty> context, ResourceKey<TrimProperty> key, TrimProperty property) {
        context.register(key, (Object)property);
    }

    private static ResourceKey<TrimProperty> key(String key) {
        return ResourceKey.create(BetterTrimsRegistries.Keys.TRIM_PROPERTIES, (ResourceLocation)BetterTrims.rl(key));
    }
}

