/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.client.mixin.accessor.CompositeLootItemConditionAccessor;
import com.bawnorton.bettertrims.client.mixin.accessor.IntRangeAccessor;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeBuilder;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.component.ConditionalComponent;
import com.bawnorton.bettertrims.client.tooltip.component.CyclingComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.BlockPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.DamageSourcePredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.EntityPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.ItemPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.LocationPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Formatter;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.condition.DimensionCheck;
import com.bawnorton.bettertrims.util.TriState;
import com.bawnorton.bettertrims.version.VRegistry;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.class_156;
import net.minecraft.class_186;
import net.minecraft.class_1887;
import net.minecraft.class_2022;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_217;
import net.minecraft.class_219;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_42;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_5342;
import net.minecraft.class_5658;
import net.minecraft.class_5660;
import net.minecraft.class_5664;
import net.minecraft.class_5667;
import net.minecraft.class_5670;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8548;
import net.minecraft.class_9432;
import net.minecraft.class_9753;
import org.jetbrains.annotations.NotNull;

public interface LootConditionTooltips {
    public static final Map<class_5342, LootTooltipAdder<?>> TOOLTIPS = (Map)class_156.method_654(new HashMap(), map -> {
        map.put(class_217.field_25235, (level, condition, parentBuilder, state) -> {
            class_5341 term = condition.comp_1873();
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            LootConditionTooltips.addConditionToTooltip(level, term, builder, state.withInverted(!state.doInvert()));
            parentBuilder.component(builder.build());
        });
        LootTooltipAdder<class_186> compositeFactory = (level, condition, parentBuilder, state) -> {
            CompositeLootItemConditionAccessor composite = (CompositeLootItemConditionAccessor)condition;
            CompositeContainerComponent.Builder builder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.condition.%s.%s".formatted(condition instanceof class_8548 ? "all_of" : "any_of", state.key()), Styler::condition, new Object[0])).vertical();
            for (class_5341 term : composite.bettertrims$terms()) {
                CompositeBuilder termBuilder = CompositeContainerComponent.builder().literal("\u2022 ", Styler::condition);
                LootConditionTooltips.addConditionToTooltip(level, term, (CompositeContainerComponent.Builder)termBuilder, state.withInverted(false));
                builder.component(((CompositeContainerComponent.Builder)termBuilder).build());
            }
            parentBuilder.component(builder.build());
        };
        map.put(class_217.field_44789, compositeFactory);
        map.put(class_217.field_44790, compositeFactory);
        map.put(class_217.field_25237, (level, condition, parentBuilder, state) -> {
            class_219 chanceCondition = (class_219)condition;
            parentBuilder.cycle(chanceCycler -> LootConditionTooltips.numberCompFromNumberProvider(chanceCondition.comp_2781(), value -> {
                if (state.doInvert()) {
                    value = Float.valueOf(1.0f - value.floatValue());
                }
                return Formatter.percentage(value);
            }, comp -> comp.method_27661().method_27693("%")).forEach(numberComp -> {
                class_5250 tooltip = Styler.condition(class_2561.method_43469((String)"bettertrims.tooltip.condition.random_chance", (Object[])new Object[]{numberComp}));
                chanceCycler.textComponent((class_2561)tooltip);
            }));
            state.withUseIf(false);
        });
        map.put(class_217.field_51811, (level, condition, parentBuilder, state) -> {
            class_2378 registry = VRegistry.get(level, class_7924.field_41265);
            class_1887 enchantment = (class_1887)condition.comp_2783().method_40229().map(arg_0 -> registry.method_31140(arg_0), Function.identity());
            HashMap<Integer, Float> chanceMap = new HashMap<Integer, Float>();
            for (int i = 1; i <= enchantment.method_8183(); ++i) {
                chanceMap.put(i, Float.valueOf(condition.comp_2866().method_60188(i)));
            }
            class_5250 enchantmentName = Styler.name(enchantment.comp_2686().method_27661());
            parentBuilder.component(((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.condition.random_chance_with_enchanted_bonus.enchanted.%s".formatted(state.key()), Styler::condition, new Object[]{enchantmentName})).space().cycle(levelCycler -> chanceMap.forEach((enchantLevel, chance) -> {
                class_5250 levelComp = Styler.value(class_2561.method_43471((String)("enchantment.level." + enchantLevel))).method_27693(": ");
                class_5250 chanceComp = Styler.number(Formatter.percentage(chance));
                levelCycler.textComponent((class_2561)levelComp.method_10852((class_2561)chanceComp));
            })).literal(",").space().translate("bettertrims.tooltip.condition.random_chance_with_enchanted_bonus.else", Styler::condition, new Object[]{Styler.number(Formatter.percentage(Float.valueOf(condition.comp_2865())))})).build());
        });
        map.put(class_217.field_25239, (level, condition, parentBuilder, state) -> {
            Optional predicate = condition.comp_1879();
            if (predicate.isEmpty()) {
                return;
            }
            class_5250 target = Styler.target(class_2561.method_43471((String)"bettertrims.tooltip.condition.entity_properties.%s.%s".formatted(state.key(), condition.comp_1880().method_15434())));
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder().vertical();
            EntityPredicateTooltip.addToBuilder(level, (class_2048)predicate.orElseThrow(), state, builder);
            parentBuilder.textComponent((class_2561)target).component(builder.build());
        });
        map.put(class_217.field_25240, (level, condition, parentBuilder, state) -> parentBuilder.textComponent((class_2561)Styler.condition(class_2561.method_43471((String)"bettertrims.tooltip.condition.killed_by_player.%s".formatted(state.key())))));
        map.put(class_217.field_25241, (level, condition, parentBuilder, state) -> {
            class_5250 target = Styler.target(class_2561.method_43471((String)"bettertrims.tooltip.condition.entity_properties.%s.%s".formatted(state.key(), condition.comp_1872().method_15434())));
            Map scores = condition.comp_1871();
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            builder.cycle(arg_0 -> LootConditionTooltips.lambda$static$14(scores, state, (class_2561)target, arg_0));
        });
        map.put(class_217.field_25242, (level, condition, parentBuilder, state) -> {
            class_2378 registry = VRegistry.get(level, class_7924.field_41254);
            class_6880 block = condition.comp_1876();
            class_5250 blockName = Styler.name(((class_2248)block.method_40229().map(arg_0 -> registry.method_31140(arg_0), Function.identity())).method_9518());
            Optional properties = condition.comp_1877();
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            if (properties.isPresent()) {
                class_5250 target = Styler.condition(class_2561.method_43469((String)"bettertrims.tooltip.condition.block_state_property.with_properties.%s".formatted(state.key()), (Object[])new Object[]{blockName}));
                builder.textComponent((class_2561)target);
                BlockPredicateTooltip.addStatePropertiesPredicateToBuilder(level, (class_4559)properties.orElseThrow(), state, builder);
            } else {
                class_5250 target = Styler.condition(class_2561.method_43469((String)"bettertrims.tooltip.condition.block_state_property.%s".formatted(state.key()), (Object[])new Object[]{blockName}));
                builder.textComponent((class_2561)target);
            }
            parentBuilder.component(builder.build());
        });
        map.put(class_217.field_25243, (level, matchTool, parentBuilder, state) -> {
            Optional predicate = matchTool.comp_1884();
            if (predicate.isEmpty()) {
                return;
            }
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            builder.translate("bettertrims.tooltip.condition.match_tool", Styler::target, new Object[0]);
            ItemPredicateTooltip.addToBuilder(level, (class_2073)predicate.orElseThrow(), state, builder);
            parentBuilder.component(builder.build());
        });
        map.put(class_217.field_25244, (level, condition, parentBuilder, state) -> {
            class_6880 enchantment = condition.comp_1867();
            List values = condition.comp_1868();
            class_2378 registry = VRegistry.get(level, class_7924.field_41265);
            class_5250 enchantmentName = Styler.name(((class_1887)enchantment.method_40229().map(arg_0 -> registry.method_31140(arg_0), Function.identity())).comp_2686().method_27661());
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            ((CompositeContainerComponent.Builder)builder.translate("bettertrims.tooltip.condition.table_bonus.%s".formatted(state.key()), Styler::condition, new Object[]{enchantmentName})).space().cycle(cycler -> {
                for (int i = 0; i < values.size(); ++i) {
                    float value = ((Float)values.get(i)).floatValue();
                    class_5250 levelComp = Styler.value(class_2561.method_43471((String)("enchantment.level." + (i + 1)))).method_27693(": ");
                    class_5250 valueComp = Styler.number(Formatter.decimal(Float.valueOf(value)));
                    cycler.textComponent((class_2561)levelComp.method_10852((class_2561)valueComp));
                }
            });
            parentBuilder.component(builder.build());
        });
        map.put(class_217.field_25245, (level, condition, parentBuilder, state) -> parentBuilder.textComponent((class_2561)Styler.condition(class_2561.method_43471((String)"bettertrims.tooltip.condition.survives_explosion.%s".formatted(state.key())))));
        map.put(class_217.field_25246, (level, condition, parentBuilder, state) -> {
            Optional predicate = condition.comp_1870();
            if (predicate.isEmpty()) {
                return;
            }
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            builder.translate("bettertrims.tooltip.condition.damage_source_properties.%s".formatted(state.key()), Styler::condition, new Object[0]);
            DamageSourcePredicateTooltip.addToBuilder(level, (class_2022)predicate.orElseThrow(), state, builder);
            parentBuilder.component(builder.build());
        });
        map.put(class_217.field_25247, (level, locationCheck, parentBuilder, state) -> {
            Optional predicate = locationCheck.comp_1874();
            if (predicate.isEmpty()) {
                return;
            }
            class_2338 offset = locationCheck.comp_1875();
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            LocationPredicateTooltip.addToBuilder(level, (class_2090)predicate.orElseThrow(), state, builder);
            if (!offset.equals((Object)class_2338.field_10980)) {
                class_5250 offsetComp = Styler.value(class_2561.method_43470((String)"(%d, %d, %d)".formatted(offset.method_10263(), offset.method_10264(), offset.method_10260())));
                builder.space().translate("bettertrims.tooltip.condition.location_check.offset", Styler::condition, new Object[]{offsetComp});
            }
            parentBuilder.component(builder.build());
        });
        map.put(class_217.field_25248, (level, weatherCheck, parentBuilder, state) -> {
            Optional raining = weatherCheck.comp_1889();
            Optional thundering = weatherCheck.comp_1890();
            if (raining.isEmpty() && thundering.isEmpty()) {
                return;
            }
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            if (raining.isPresent() && thundering.isPresent()) {
                builder.translate("bettertrims.tooltip.condition.weather_check.both.%s".formatted(state.key()), Styler::condition, new Object[]{Styler.value(class_2561.method_43471((String)"bettertrims.tooltip.condition.weather_check.raining.%s".formatted((Boolean)raining.get() != false ? "true" : "false"))), Styler.value(class_2561.method_43471((String)"bettertrims.tooltip.condition.weather_check.thundering.%s".formatted((Boolean)thundering.get() != false ? "true" : "false")))});
            } else if (raining.isPresent()) {
                builder.translate("bettertrims.tooltip.condition.weather_check.raining.%s".formatted(state.key()), Styler::condition, new Object[]{Styler.value(class_2561.method_43471((String)"bettertrims.tooltip.condition.weather_check.raining.%s".formatted((Boolean)raining.get() != false ? "true" : "false")))});
            } else {
                builder.translate("bettertrims.tooltip.condition.weather_check.thundering.%s".formatted(state.key()), Styler::condition, new Object[]{Styler.value(class_2561.method_43471((String)"bettertrims.tooltip.condition.weather_check.thundering.%s".formatted((Boolean)thundering.get() != false ? "true" : "false")))});
            }
            parentBuilder.component(builder.build());
        });
        map.put(class_217.field_25249, (level, conditionReference, parentBuilder, state) -> {
            class_5321 name = conditionReference.comp_1869();
            class_2960 id = name.method_29177();
            parentBuilder.textComponent((class_2561)Styler.condition(class_2561.method_43469((String)"bettertrims.tooltip.condition.reference.%s".formatted(state.key()), (Object[])new Object[]{Styler.name(class_2561.method_43470((String)id.toString()))})));
        });
        map.put(class_217.field_25250, (level, timeCheck, parentBuilder, state) -> {
            class_42 value = timeCheck.comp_1886();
            Optional period = timeCheck.comp_1885();
            IntRangeAccessor accessor = (IntRangeAccessor)value;
            class_5658 min = accessor.bettertrims$min();
            class_5658 max = accessor.bettertrims$max();
            Function<Float, class_5250> formatter = ticks -> {
                String ampm;
                long totalSeconds = (long)Math.round(ticks.floatValue() / 20.0f) * 72L;
                long totalMinutes = TimeUnit.SECONDS.toMinutes(totalSeconds);
                long totalHours = TimeUnit.MINUTES.toHours(totalMinutes);
                long days = TimeUnit.HOURS.toDays(totalHours);
                long minutes = totalMinutes % 60L;
                long hours = (totalHours + 6L) % 24L;
                String string = ampm = hours >= 12L ? "pm" : "am";
                if ((hours %= 12L) == 0L) {
                    hours = 12L;
                }
                if (days > 0L) {
                    return class_2561.method_43470((String)"%d:%02d%s + %d Days".formatted(hours, minutes, ampm, days));
                }
                return class_2561.method_43470((String)"%d:%02d%s".formatted(hours, minutes, ampm));
            };
            List<class_2561> minComps = min == null ? LootConditionTooltips.numberCompFromNumberProvider((class_5658)new class_44(0.0f), formatter, UnaryOperator.identity()) : LootConditionTooltips.numberCompFromNumberProvider(min, formatter, UnaryOperator.identity());
            List<class_2561> maxComps = max == null ? LootConditionTooltips.numberCompFromNumberProvider((class_5658)new class_44(24000.0f), formatter, UnaryOperator.identity()) : LootConditionTooltips.numberCompFromNumberProvider(max, formatter, UnaryOperator.identity());
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)builder.translate("bettertrims.tooltip.condition.time_check.%s".formatted(state.key()), Styler::condition, new Object[0])).space().translate("bettertrims.tooltip.condition.time_check.between", Styler::condition, new Object[0])).space().cycle(cycleBuilder -> minComps.forEach(cycleBuilder::textComponent)).literal(" & ", Styler::condition)).cycle(cycleBuilder -> maxComps.forEach(cycleBuilder::textComponent));
            if (period.isPresent()) {
                float periodTicks = ((Long)period.orElseThrow()).longValue();
                long totalSeconds = (long)Math.round(periodTicks / 20.0f) * 72L;
                long totalMinutes = TimeUnit.SECONDS.toMinutes(totalSeconds);
                long totalHours = TimeUnit.MINUTES.toHours(totalMinutes);
                long days = TimeUnit.HOURS.toDays(totalHours);
                long minutes = totalMinutes % 60L;
                long hours = totalHours % 24L;
                StringBuilder formattedPeriod = new StringBuilder();
                if (days > 0L) {
                    if (days == 1L) {
                        formattedPeriod.append("Day");
                    } else {
                        formattedPeriod.append("%d Days".formatted(days));
                    }
                }
                if (hours > 0L) {
                    if (!formattedPeriod.isEmpty()) {
                        formattedPeriod.append(", %d Hours".formatted(hours));
                    } else if (hours == 1L) {
                        formattedPeriod.append("Hour");
                    } else {
                        formattedPeriod.append("%d Hours".formatted(hours));
                    }
                }
                if (minutes > 0L) {
                    if (!formattedPeriod.isEmpty()) {
                        formattedPeriod.append(", %d Minutes".formatted(minutes));
                    } else if (minutes == 1L) {
                        formattedPeriod.append("Minute");
                    } else {
                        formattedPeriod.append("%d Minutes".formatted(minutes));
                    }
                }
                if (formattedPeriod.isEmpty()) {
                    formattedPeriod.append("%d Seconds".formatted(totalSeconds));
                }
                builder.space().translate("bettertrims.tooltip.condition.time_check.period", Styler::condition, new Object[]{Styler.value(class_2561.method_43470((String)formattedPeriod.toString()))});
            }
            parentBuilder.component(builder.build());
        });
        map.put(class_217.field_27911, (level, condition, parentBuilder, state) -> {
            class_5658 provider = condition.comp_1887();
            class_42 range = condition.comp_1888();
            IntRangeAccessor accessor = (IntRangeAccessor)range;
            class_5658 min = accessor.bettertrims$min();
            class_5658 max = accessor.bettertrims$max();
            List<class_2561> providerComps = LootConditionTooltips.numberCompFromNumberProvider(provider, Formatter::decimal, UnaryOperator.identity());
            List<class_2561> minComps = min == null ? null : LootConditionTooltips.numberCompFromNumberProvider(min, Formatter::decimal, UnaryOperator.identity());
            List<class_2561> maxComps = max == null ? null : LootConditionTooltips.numberCompFromNumberProvider(max, Formatter::decimal, UnaryOperator.identity());
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            ((CompositeContainerComponent.Builder)builder.translate("bettertrims.tooltip.condition.value_check.%s".formatted(state.key()), Styler::condition, new Object[]{providerComps})).space();
            if (minComps != null && maxComps != null) {
                builder.translate("bettertrims.tooltip.condition.value_check.between", Styler::condition, new Object[]{minComps, maxComps});
            } else if (minComps != null) {
                builder.translate("bettertrims.tooltip.condition.value_check.at_least", Styler::condition, new Object[]{minComps});
            } else if (maxComps != null) {
                builder.translate("bettertrims.tooltip.condition.value_check.at_most", Styler::condition, new Object[]{maxComps});
            } else {
                builder.translate("bettertrims.tooltip.condition.value_check.any_value", Styler::condition, new Object[0]);
            }
            parentBuilder.component(builder.build());
        });
        map.put(class_217.field_51812, (level, condition, parentBuilder, state) -> parentBuilder.translate("bettertrims.tooltip.condition.enchantment_active_check.%s.%S".formatted(state.key(), condition.comp_2780()), Styler::condition, new Object[0]));
        map.put(DimensionCheck.TYPE, (level, condition, parentBuilder, state) -> {
            class_6885<class_2874> dimensions = condition.dimensions();
            PredicateTooltip.addRegisteredElementsToBuilder(level, "bettertrims.tooltip.condition.dimension_check.%s".formatted(state.key()), class_7924.field_41241, dimensions, state.withPrefixSpace(false), parentBuilder);
        });
    });

    public static CompositeContainerComponent getTooltip(class_638 level, class_327 font, class_5341 condition) {
        State state = new State();
        CompositeContainerComponent.Builder conditionBuilder = CompositeContainerComponent.builder();
        LootConditionTooltips.addConditionToTooltip(level, condition, conditionBuilder, state);
        CompositeContainerComponent conditionComponent = conditionBuilder.build();
        CompositeContainerComponent.Builder root = CompositeContainerComponent.builder();
        if (state.doUseIf()) {
            ((CompositeContainerComponent.Builder)root.translate("bettertrims.tooltip.condition.if", Styler::condition, new Object[0])).space();
        }
        if (conditionComponent.isOneLine()) {
            return root.component(conditionComponent).build();
        }
        return root.component(CompositeContainerComponent.builder().component(new ConditionalComponent((class_5684)new class_5683(Styler.condition(class_2561.method_43469((String)"bettertrims.tooltip.condition.hold_shift", (Object[])new Object[]{Styler.trim(class_2561.method_43470((String)"[LSHFT]"))})).method_30937()), conditionComponent, () -> !class_310.method_1551().method_74187() && !BetterTrims.debug)).build()).build();
    }

    private static void addConditionToTooltip(class_638 level, class_5341 condition, CompositeContainerComponent.Builder builder, State state) {
        LootTooltipAdder<?> factory = TOOLTIPS.getOrDefault(condition.method_29325(), LootTooltipAdder.EMPTY);
        factory.addToBuilder(level, condition, builder, state);
    }

    @NotNull
    private static List<class_2561> numberCompFromNumberProvider(class_5658 numberProvider, Function<Float, class_5250> valueFormatter, UnaryOperator<class_2561> literalFormatter) {
        class_5658 class_56582 = numberProvider;
        Objects.requireNonNull(class_56582);
        class_5658 class_56583 = class_56582;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_44.class, class_5660.class, class_9753.class, class_9432.class}, (Object)class_56583, n)) {
            case 0 -> {
                class_44 constant = (class_44)class_56583;
                yield List.of(Styler.number(valueFormatter.apply(Float.valueOf(constant.comp_1895()))));
            }
            case 1 -> {
                class_5660 scoreboardValue = (class_5660)class_56583;
                class_5250 score = Styler.property(class_2561.method_43470((String)scoreboardValue.comp_1898()));
                class_5670 v2 = scoreboardValue.comp_1897();
                Objects.requireNonNull(v2);
                class_5670 var9_9 = v2;
                int var10_12 = 0;
                class_5250 v3 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_5667.class, class_5664.class}, (Object)var9_9, var10_12)) {
                    case 0 -> {
                        class_5667 fixed = (class_5667)var9_9;
                        yield class_2561.method_43470((String)fixed.comp_1903());
                    }
                    case 1 -> {
                        class_5664 context = (class_5664)var9_9;
                        yield class_2561.method_43471((String)"bettertrims.tooltip.condition.context_scoreboard_name.%s".formatted(context.comp_1902().method_15434()));
                    }
                    default -> class_2561.method_43470((String)"[?]");
                };
                class_5250 targetComp = Styler.name(v3);
                yield List.of(Styler.condition(((class_2561)literalFormatter.apply((class_2561)class_2561.method_43469((String)"bettertrims.tooltip.condition.number_provider.scoreboard", (Object[])new Object[]{targetComp, score}))).method_27661()));
            }
            case 2 -> {
                class_9753 levelProvider = (class_9753)class_56583;
                ArrayList<class_5250> components = new ArrayList<class_5250>();
                for (int i = 1; i <= 5; ++i) {
                    float value = levelProvider.comp_2784().method_60188(i);
                    class_5250 formattedValue = valueFormatter.apply(Float.valueOf(value));
                    class_5250 enchantmentLevelComp = Styler.value(class_2561.method_43471((String)("enchantment.level." + i)));
                    components.add(enchantmentLevelComp.method_27693(": ").method_10852((class_2561)Styler.number(formattedValue)));
                }
                yield components;
            }
            case 3 -> {
                class_9432 storageValue = (class_9432)class_56583;
                class_5250 pathComp = Styler.value(class_2561.method_43470((String)storageValue.comp_2526().method_54100()));
                class_5250 storageComp = Styler.name(class_2561.method_43470((String)storageValue.comp_2525().toString()));
                yield List.of((class_2561)literalFormatter.apply((class_2561)class_2561.method_43469((String)"bettertrims.tooltip.condition.number_provider.storage", (Object[])new Object[]{pathComp, storageComp})));
            }
            default -> List.of(class_2561.method_43471((String)"bettertrims.tooltip.condition.number_provider.complex"));
        };
    }

    private static /* synthetic */ void lambda$static$14(Map scores, State state, class_2561 target, CyclingComponent.Builder scoreCycler) {
        scores.forEach((score, range) -> {
            IntRangeAccessor accessor = (IntRangeAccessor)range;
            class_5658 min = accessor.bettertrims$min();
            class_5658 max = accessor.bettertrims$max();
            List<class_2561> minComps = min == null ? null : LootConditionTooltips.numberCompFromNumberProvider(min, Formatter::decimal, UnaryOperator.identity());
            List<class_2561> maxComps = max == null ? null : LootConditionTooltips.numberCompFromNumberProvider(max, Formatter::decimal, UnaryOperator.identity());
            class_5250 scoreComp = Styler.property(class_2561.method_43470((String)score));
            if (minComps != null && maxComps != null) {
                scoreCycler.textComponent((class_2561)Styler.condition(class_2561.method_43469((String)"bettertrims.tooltip.condition.entity_scores.between.%s".formatted(state.key()), (Object[])new Object[]{target, scoreComp, minComps, maxComps})));
            } else if (minComps != null) {
                scoreCycler.textComponent((class_2561)Styler.condition(class_2561.method_43469((String)"bettertrims.tooltip.condition.entity_scores.at_least.%s".formatted(state.key()), (Object[])new Object[]{target, scoreComp, minComps})));
            } else if (maxComps != null) {
                scoreCycler.textComponent((class_2561)Styler.condition(class_2561.method_43469((String)"bettertrims.tooltip.condition.entity_scores.at_most.%s".formatted(state.key()), (Object[])new Object[]{target, scoreComp, maxComps})));
            } else {
                scoreCycler.textComponent((class_2561)Styler.condition(class_2561.method_43469((String)"bettertrims.tooltip.condition.entity_scores.any_value.%s".formatted(state.key()), (Object[])new Object[]{target, scoreComp})));
            }
        });
    }

    public static class State {
        private final Set<StateEntry> entries = new HashSet<StateEntry>();
        private final StateEntry inverted = this.entry("inverted", false, true);
        private final StateEntry useWith = this.entry("with", false, true);
        private final StateEntry prefixSpace = this.entry("space", true, false);
        private final StateEntry useIf = this.entry("if", true, false);

        public static String normalKey() {
            return "normal";
        }

        private StateEntry entry(String key, boolean defaultValue, boolean includedInKey) {
            StateEntry stateEntry = new StateEntry(key, defaultValue, includedInKey);
            this.entries.add(stateEntry);
            return stateEntry;
        }

        public State withInverted(boolean inverted) {
            this.inverted.switchTo(inverted);
            return this;
        }

        public State withPrefixSpace(boolean prefixSpace) {
            this.prefixSpace.switchTo(prefixSpace);
            return this;
        }

        public State withUseWith(boolean useWith) {
            this.useWith.switchTo(useWith);
            return this;
        }

        public State withUseIf(boolean useIf) {
            this.useIf.switchTo(useIf);
            return this;
        }

        public boolean doInvert() {
            return this.inverted.value();
        }

        public boolean doPrefixSpace() {
            return this.prefixSpace.value();
        }

        public boolean doUseWith() {
            return this.useWith.value();
        }

        public boolean doUseIf() {
            return this.useIf.value();
        }

        public String key() {
            StringBuilder keyBuilder = new StringBuilder();
            for (StateEntry entry : this.entries) {
                if (!entry.includedInKey() || !entry.value()) continue;
                if (!keyBuilder.isEmpty()) {
                    keyBuilder.append(".");
                }
                keyBuilder.append(entry.key());
            }
            if (keyBuilder.isEmpty()) {
                return State.normalKey();
            }
            return keyBuilder.toString();
        }

        private static final class StateEntry {
            private final String key;
            private final boolean defaultValue;
            private final boolean includedInKey;
            private TriState state;

            private StateEntry(String key, boolean defaultValue, boolean includedInKey) {
                this.key = key;
                this.state = TriState.DEFAULT;
                this.defaultValue = defaultValue;
                this.includedInKey = includedInKey;
            }

            public void switchTo(boolean value) {
                this.state = value ? TriState.TRUE : TriState.FALSE;
            }

            public boolean value() {
                return this.state == TriState.DEFAULT ? this.defaultValue : this.state == TriState.TRUE;
            }

            public boolean includedInKey() {
                return this.includedInKey;
            }

            public String key() {
                return this.key;
            }
        }
    }

    public static interface LootTooltipAdder<T extends class_5341> {
        public static final LootTooltipAdder<?> EMPTY = (level, condition, builder, state) -> builder.translate("bettertrims.tooltip.condition.unknown", Styler::condition, new Object[]{((Comparable)((Object)Objects.requireNonNullElse(class_7923.field_41135.method_10221((Object)condition.method_29325()), "[unregistered]"))).toString()});

        public void addToBuilder(class_638 var1, T var2, CompositeContainerComponent.Builder var3, State var4);
    }
}

