/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.ability.type.entity;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.version.VRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5684;
import net.minecraft.class_5819;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import net.minecraft.class_638;
import net.minecraft.class_7924;
import net.minecraft.class_9734;
import org.jetbrains.annotations.Nullable;

public record SpawnParticlesAbility(class_2394 particle, class_9734.class_9735 horizontalPosition, class_9734.class_9735 verticalPosition, class_9734.class_9738 horizontalVelocity, class_9734.class_9738 verticalVelocity, class_5863 speed) implements TrimEntityAbility
{
    public static final MapCodec<SpawnParticlesAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2398.field_25125.fieldOf("particle").forGetter(SpawnParticlesAbility::particle), (App)class_9734.class_9735.field_51722.fieldOf("horizontal_position").forGetter(SpawnParticlesAbility::horizontalPosition), (App)class_9734.class_9735.field_51722.fieldOf("vertical_position").forGetter(SpawnParticlesAbility::verticalPosition), (App)class_9734.class_9738.field_51729.fieldOf("horizontal_velocity").forGetter(SpawnParticlesAbility::horizontalVelocity), (App)class_9734.class_9738.field_51729.fieldOf("vertical_velocity").forGetter(SpawnParticlesAbility::verticalVelocity), (App)class_5863.field_29007.optionalFieldOf("speed", (Object)class_5862.field_29003).forGetter(SpawnParticlesAbility::speed)).apply((Applicative)instance, SpawnParticlesAbility::new));

    @Override
    public void apply(class_3218 level, class_1309 wearer, class_1297 target, TrimmedItems items, @Nullable class_1304 targetSlot, class_243 origin) {
        class_5819 random = target.method_59922();
        class_243 targetVelocity = target.method_60478();
        float width = target.method_17681();
        float height = target.method_17682();
        level.method_65096(this.particle, this.horizontalPosition.method_60254(origin.method_10216(), origin.method_10216(), width, random), this.verticalPosition.method_60254(origin.method_10214(), origin.method_10214() + (double)(height / 2.0f), height, random), this.horizontalPosition.method_60254(origin.method_10215(), origin.method_10215(), width, random), 0, this.horizontalVelocity.method_60262(targetVelocity.method_10216(), random), this.verticalVelocity.method_60262(targetVelocity.method_10214(), random), this.horizontalVelocity.method_60262(targetVelocity.method_10215(), random), (double)this.speed.method_33920(random));
    }

    @Override
    public MapCodec<? extends TrimEntityAbility> codec() {
        return CODEC;
    }

    public static class TooltipProvider
    implements TrimElementTooltipProvider<SpawnParticlesAbility> {
        @Override
        @Nullable
        public class_5684 getTooltip(class_638 level, SpawnParticlesAbility element, boolean includeCount) {
            class_2561 particleName = TooltipProvider.getParticleName(level, element);
            if (particleName == null) {
                return null;
            }
            return ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.ability.spawn_particles.spawns", Styler::positive, new Object[0])).textComponent(particleName).translate("bettertrims.tooltip.ability.spawn_particles.particles", Styler::positive, new Object[0])).spaced().build();
        }

        @Nullable
        private static class_2561 getParticleName(class_638 level, SpawnParticlesAbility element) {
            class_2394 class_23942 = element.particle();
            Objects.requireNonNull(class_23942);
            class_2394 class_23943 = class_23942;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2388.class}, (Object)class_23943, n)) {
                case 0 -> {
                    class_2388 blockParticle = (class_2388)class_23943;
                    class_2680 state = blockParticle.method_10278();
                    class_5250 blockName = state.method_26204().method_9518();
                    yield Styler.positive(class_2561.method_43469((String)"bettertrims.tooltip.ability.spawn_particles.block", (Object[])new Object[]{Styler.name(blockName)}));
                }
                default -> {
                    class_2378 registry = VRegistry.get(level, class_7924.field_41210);
                    class_2960 particleType = registry.method_10221((Object)element.particle().method_10295());
                    if (particleType == null) {
                        yield null;
                    }
                    yield Styler.name(class_2561.method_43470((String)particleType.toString()));
                }
            };
        }
    }
}

