/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.client.tooltip.ExpandedTooltipPositioner;
import com.bawnorton.bettertrims.client.tooltip.TrimPropertiesTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.Matcher;
import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.version.VGuiGraphics;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5253;
import net.minecraft.class_5683;
import net.minecraft.class_638;
import net.minecraft.class_768;
import net.minecraft.class_8002;
import net.minecraft.class_8053;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public final class AbilityTooltipRenderer {
    private static final ThreadLocal<class_1799> STACK_CAPTURE = ThreadLocal.withInitial(() -> class_1799.field_8037);
    private static final Map<class_8053, TrimPropertiesTooltip> tooltips = new HashMap<class_8053, TrimPropertiesTooltip>();
    private static TrimPropertiesTooltip currentTooltip = null;
    private static final LongSet EXCEPTION_HASHES = new LongArraySet();

    public static void render(class_332 graphics, class_1799 stack, class_327 font, class_768 tooltipBounds, int mouseX, @Nullable class_2960 background) {
        if (stack.method_7960()) {
            return;
        }
        class_8053 trim = (class_8053)stack.method_57824(class_9334.field_49607);
        if (trim == null) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        if (level == null) {
            return;
        }
        if (!AbilityTooltipRenderer.hasProperties(level, trim)) {
            return;
        }
        boolean hasAltDown = class_437.method_25443();
        if (!hasAltDown && !BetterTrims.debug) {
            boolean shouldFlip = mouseX + tooltipBounds.method_3319() + 38 > graphics.method_51421();
            AbilityTooltipRenderer.renderPrompt(graphics, font, tooltipBounds, shouldFlip, background);
            return;
        }
        boolean shouldFlip = mouseX > tooltipBounds.method_3321();
        try {
            AbilityTooltipRenderer.renderProperties(graphics, level, font, trim, tooltipBounds, shouldFlip, background);
        }
        catch (Exception e) {
            long hash = e.getClass().getName().hashCode();
            hash ^= e.getMessage() != null ? (long)e.getMessage().hashCode() : 0L;
            for (StackTraceElement element : e.getStackTrace()) {
                hash ^= 31L * hash * (long)element.getClassName().hashCode();
                hash ^= 31L * hash * (long)element.getMethodName().hashCode();
                hash ^= 31L * hash * (long)element.getLineNumber();
            }
            if (EXCEPTION_HASHES.add(hash)) {
                BetterTrims.LOGGER.error("Failed to render trim properties tooltip for trim {} on item {}", new Object[]{trim, stack, e});
            }
            AbilityTooltipRenderer.renderError(graphics, font, tooltipBounds, shouldFlip, background);
        }
    }

    private static boolean hasProperties(class_638 level, class_8053 trim) {
        for (TrimProperty property : TrimProperties.getProperties((class_1937)level)) {
            if (!property.matcher().matches(trim)) continue;
            return true;
        }
        return false;
    }

    private static void renderProperties(class_332 graphics, class_638 level, class_327 font, class_8053 trim, class_768 tooltipBounds, boolean horizontallyFlipped, class_2960 background) {
        currentTooltip = tooltips.computeIfAbsent(trim, a -> {
            HashMap<Matcher, List<TrimProperty>> matchedProperties = new HashMap<Matcher, List<TrimProperty>>();
            for (TrimProperty property : TrimProperties.getProperties((class_1937)level)) {
                Matcher matcher = property.matcher();
                if (!matcher.matches(trim)) continue;
                matchedProperties.computeIfAbsent(matcher, m -> new ArrayList()).add(property);
            }
            TrimPropertiesTooltip tooltip = new TrimPropertiesTooltip(matchedProperties);
            tooltip.generatePages(level, font);
            return tooltip;
        });
        currentTooltip.render(graphics, level, font, tooltipBounds, horizontallyFlipped, background);
    }

    private static void renderPrompt(class_332 graphics, class_327 font, class_768 tooltipBounds, boolean horizontallyFlipped, @Nullable class_2960 background) {
        int promptWidth = 8;
        int promptHeight = 8;
        int xOffset = tooltipBounds.method_3321() + (horizontallyFlipped ? -promptWidth - 10 : tooltipBounds.method_3319() + 10);
        int yOffset = tooltipBounds.method_3322();
        if (class_310.field_1703) {
            graphics.method_51448().method_22903();
            graphics.method_51741(() -> class_8002.method_47946((class_332)graphics, (int)xOffset, (int)yOffset, (int)promptWidth, (int)promptHeight, (int)400));
            graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
            int colour = class_124.field_1065.method_532();
            float[] existing = new float[4];
            for (int i = 0; i < 4; ++i) {
                existing[i] = RenderSystem.getShaderColor()[i];
            }
            RenderSystem.setShaderColor((float)((float)class_5253.class_5254.method_27765((int)colour) / 255.0f), (float)((float)class_5253.class_5254.method_27766((int)colour) / 255.0f), (float)((float)class_5253.class_5254.method_27767((int)colour) / 255.0f), (float)1.0f);
            graphics.method_52706(BetterTrims.rl("text/alt"), xOffset, yOffset, promptWidth, promptHeight);
            RenderSystem.setShaderColor((float)existing[0], (float)existing[1], (float)existing[2], (float)existing[3]);
            graphics.method_51448().method_22909();
        } else {
            VGuiGraphics.renderTooltip(graphics, font, List.of(new class_5683(class_2561.method_43470((String)"Alt").method_27694(Styler::trim).method_30937())), xOffset - 10, yOffset, new ExpandedTooltipPositioner(tooltipBounds.method_3319()), background);
        }
    }

    private static void renderError(class_332 graphics, class_327 font, class_768 tooltipBounds, boolean shouldFlip, @Nullable class_2960 background) {
        List<class_5683> errorComponents = List.of(new class_5683(class_2561.method_43471((String)"bettertrims.tooltip.properties.error").method_27692(class_124.field_1061).method_30937()));
        int offsetX = tooltipBounds.method_3321() + tooltipBounds.method_3319() + (shouldFlip ? 14 : 0);
        int offsetY = tooltipBounds.method_3322();
        VGuiGraphics.renderTooltip(graphics, font, errorComponents, offsetX, offsetY, new ExpandedTooltipPositioner(tooltipBounds.method_3319()), background);
    }

    public static boolean mouseScrolled(double scrollY) {
        if (currentTooltip == null) {
            return false;
        }
        return currentTooltip.mouseScrolled(scrollY);
    }

    public static void clearRendering() {
        currentTooltip = null;
    }

    public static void setStack(class_1799 stack) {
        STACK_CAPTURE.set(stack);
    }

    public static class_1799 getStack() {
        return STACK_CAPTURE.get();
    }

    public static void clearStack() {
        STACK_CAPTURE.remove();
    }
}

