/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6898;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9334;

public final class Matcher {
    public static final Codec<Matcher> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6898.method_40388((class_5321)class_7924.field_42083, (Codec)class_8054.field_42003, (boolean)false).optionalFieldOf("material", (Object)class_6885.method_58563()).forGetter(Matcher::material), (App)class_6898.method_40388((class_5321)class_7924.field_42082, (Codec)class_8056.field_42015, (boolean)false).optionalFieldOf("pattern", (Object)class_6885.method_58563()).forGetter(Matcher::pattern), (App)class_5699.method_48766((int)1, (int)255).optionalFieldOf("min_count", (Object)1).forGetter(Matcher::minCount)).apply((Applicative)instance, Matcher::new));
    private final class_6885<class_8054> material;
    private final class_6885<class_8056> pattern;
    private final int minCount;
    private final Map<class_8053, Boolean> matchingCache = new WeakHashMap<class_8053, Boolean>();

    public Matcher(class_6885<class_8054> material, class_6885<class_8056> pattern, int minCount) {
        this.material = material;
        this.pattern = pattern;
        this.minCount = minCount;
    }

    public static Matcher forMaterial(class_6885<class_8054> material, int minCount) {
        return new Matcher(material, (class_6885<class_8056>)class_6885.method_58563(), minCount);
    }

    public static Matcher forPattern(class_6885<class_8056> pattern, int minCount) {
        return new Matcher((class_6885<class_8054>)class_6885.method_58563(), pattern, minCount);
    }

    public Map<class_1304, class_1799> getMatchingStacks(class_1309 wearer) {
        HashMap<class_1304, class_1799> stacks = new HashMap<class_1304, class_1799>();
        for (class_1304 slot : class_1304.values()) {
            class_1799 stack = wearer.method_6118(slot);
            class_1304 shouldBeInSlot = wearer.method_32326(stack);
            if (slot != shouldBeInSlot || !this.matches(stack)) continue;
            stacks.put(slot, stack);
        }
        return stacks;
    }

    public boolean matches(class_1309 wearer, class_1799 stack, class_1304 slot) {
        class_1304 shouldBeInSlot = wearer.method_32326(stack);
        return shouldBeInSlot == slot && this.matches(stack);
    }

    public boolean matches(class_1799 stack) {
        class_8053 trim = (class_8053)stack.method_57824(class_9334.field_49607);
        if (trim == null) {
            return false;
        }
        return this.matches(trim);
    }

    public boolean matches(class_8053 trim) {
        if (this.matchingCache.containsKey(trim)) {
            return this.matchingCache.get(trim);
        }
        class_6880 material = trim.method_48431();
        class_6880 pattern = trim.method_48424();
        boolean matchesMaterial = this.material.method_40241(material) || !(this.material instanceof class_6885.class_6888) && this.material.method_40247() == 0;
        boolean matchesPattern = this.pattern.method_40241(pattern) || !(this.pattern instanceof class_6885.class_6888) && this.pattern.method_40247() == 0;
        boolean result = matchesMaterial && matchesPattern;
        this.matchingCache.put(trim, result);
        return result;
    }

    public class_6885<class_8054> material() {
        return this.material;
    }

    public class_6885<class_8056> pattern() {
        return this.pattern;
    }

    public int minCount() {
        return this.minCount;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Matcher that = (Matcher)obj;
        return Objects.equals(this.material, that.material) && Objects.equals(this.pattern, that.pattern) && this.minCount == that.minCount;
    }

    public int hashCode() {
        return Objects.hash(this.material, this.pattern, this.minCount);
    }

    public String toString() {
        return "Matcher[material=" + String.valueOf(this.material) + ", pattern=" + String.valueOf(this.pattern) + ", minCount=" + this.minCount + "]";
    }
}

