/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.client.BetterTrimsClient;
import com.bawnorton.bettertrims.client.tooltip.TooltipComponentOptimiser;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.component.CyclingComponent;
import com.bawnorton.bettertrims.client.tooltip.component.DynamicWidthComponent;
import com.bawnorton.bettertrims.client.tooltip.component.ItemComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltips;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.Matcher;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.element.ConditionalElement;
import com.bawnorton.bettertrims.property.element.ConditionalElementMatcher;
import com.bawnorton.bettertrims.property.element.TrimElement;
import com.bawnorton.bettertrims.property.item.TrimItemPropertyComponents;
import com.bawnorton.bettertrims.registry.BetterTrimsRegistries;
import com.bawnorton.bettertrims.version.VRegistry;
import com.bawnorton.bettertrims.version.VTrims;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class TrimTooltipPage {
    private final Matcher matcher;
    private final TrimProperty property;
    private ClientTooltipComponent component;

    public TrimTooltipPage(TrimProperty property, Matcher matcher) {
        this.matcher = matcher;
        this.property = property;
    }

    private static ClientTooltipComponent generateAsItemHeader() {
        return ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.properties.as_item", Styler::normal, new Object[0])).build();
    }

    @NotNull
    private static List<ItemStack> getPatternProviders(List<TrimPattern> patterns, ClientLevel level) {
        ArrayList<ItemStack> patternProviders = new ArrayList<ItemStack>();
        for (Map.Entry<Holder<TrimPattern>, HolderSet<Item>> entry : BetterTrimsClient.getPatternSources().entrySet()) {
            Holder<TrimPattern> patternHolder = entry.getKey();
            TrimPattern pattern = (TrimPattern)patternHolder.unwrap().map(key -> (TrimPattern)VRegistry.get(level, Registries.TRIM_PATTERN).getValueOrThrow(key), Function.identity());
            if (!patterns.contains(pattern)) continue;
            HolderSet<Item> itemHolders = entry.getValue();
            patternProviders.addAll(itemHolders.stream().map(holder -> (Item)holder.unwrap().map(key -> (Item)VRegistry.get(level, Registries.ITEM).getValueOrThrow(key), Function.identity())).map(Item::getDefaultInstance).toList());
        }
        return patternProviders;
    }

    public static ClientTooltipComponent generateMatcherComponent(ClientLevel level, HolderSet<TrimMaterial> materials, HolderSet<TrimPattern> patterns) {
        List<TrimMaterial> materialList = materials.stream().map(Holder::value).toList();
        List<TrimPattern> patternList = patterns.stream().map(Holder::value).toList();
        if (materialList.isEmpty()) {
            return TrimTooltipPage.generateAnyMaterialComponent(patternList, level);
        }
        if (patternList.isEmpty()) {
            return TrimTooltipPage.generateAnyPatternComponent(materialList, level);
        }
        return TrimTooltipPage.generateSpecificMaterialPatternComponent(patternList, materialList, level);
    }

    private static ClientTooltipComponent generateAnyMaterialComponent(List<TrimPattern> patterns, ClientLevel level) {
        if (patterns.isEmpty()) {
            return TrimTooltipPage.generateAnyMaterialOrPatternComponent(level);
        }
        return TrimTooltipPage.generateMatcherComponentFor(TrimTooltipPage.getAllMaterialProviders(level), TrimTooltipPage.getPatternProviders(patterns, level));
    }

    private static ClientTooltipComponent generateAnyPatternComponent(List<TrimMaterial> materials, ClientLevel level) {
        if (materials.isEmpty()) {
            return TrimTooltipPage.generateAnyMaterialOrPatternComponent(level);
        }
        return TrimTooltipPage.generateMatcherComponentFor(TrimTooltipPage.getMaterialProviders(materials, level), TrimTooltipPage.getAllPatternProviders(level));
    }

    private static ClientTooltipComponent generateAnyMaterialOrPatternComponent(ClientLevel level) {
        return TrimTooltipPage.generateMatcherComponentFor(TrimTooltipPage.getAllMaterialProviders(level), TrimTooltipPage.getAllPatternProviders(level));
    }

    private static ClientTooltipComponent generateSpecificMaterialPatternComponent(List<TrimPattern> patterns, List<TrimMaterial> materials, ClientLevel level) {
        return TrimTooltipPage.generateMatcherComponentFor(TrimTooltipPage.getMaterialProviders(materials, level), TrimTooltipPage.getPatternProviders(patterns, level));
    }

    private static ClientTooltipComponent generateMatcherComponentFor(List<ItemStack> materialProviders, List<ItemStack> patternProviders) {
        return ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().cycle(builder -> materialProviders.stream().map(ItemComponent::new).forEach(builder::component)).literal("-", Styler::trim)).cycle(builder -> patternProviders.stream().map(ItemComponent::new).forEach(builder::component)).spaced().centred(true).build();
    }

    private static List<ItemStack> getMaterialProviders(List<TrimMaterial> materials, ClientLevel level) {
        return TrimTooltipPage.getAllMaterialProviders(level).stream().filter(item -> {
            TrimMaterial material = VTrims.getMaterialFromStack(level, item);
            return material != null && materials.contains(material);
        }).toList();
    }

    private static List<ItemStack> getAllMaterialProviders(ClientLevel level) {
        return VRegistry.get(level, Registries.ITEM).stream().map(Item::getDefaultInstance).filter(stack -> VTrims.getMaterialFromStack(level, stack) != null).toList();
    }

    private static List<ItemStack> getAllPatternProviders(ClientLevel level) {
        return BetterTrimsClient.getPatternSources().values().stream().map(HolderSet::stream).flatMap(stream -> stream.map(holder -> (Item)holder.unwrap().map(key -> (Item)VRegistry.get(level, Registries.ITEM).getValueOrThrow(key), Function.identity()))).map(Item::getDefaultInstance).toList();
    }

    public ClientTooltipComponent getComponent() {
        if (this.component == null) {
            throw new IllegalStateException("Components have not been generated yet");
        }
        return this.component;
    }

    public void generateComponent(ClientLevel level, Font font, int index, int total) {
        Component typeTooltip;
        DataComponentType castType;
        this.component = null;
        CompositeContainerComponent.Builder pageBuilder = CompositeContainerComponent.builder().vertical();
        pageBuilder.component(this.generateTitle(level, index, total));
        boolean addHeader = true;
        boolean hasAbilities = false;
        for (DataComponentType type : BetterTrimsRegistries.TRIM_ABILITY_COMPONENT_TYPE) {
            castType = type;
            CompositeContainerComponent abilityComponent = this.generateAbilityTooltipComponent(level, font, (DataComponentType<List<ConditionalElement<TrimElement>>>)castType);
            if (abilityComponent == null) continue;
            hasAbilities = true;
            if (addHeader) {
                pageBuilder.component(this.generateWearingAbilityHeader(level));
                addHeader = false;
            }
            typeTooltip = TrimAbilityComponents.TOOLTIPS.get(BetterTrimsRegistries.TRIM_ABILITY_COMPONENT_TYPE.getKey((Object)type));
            this.generateElementComponent(pageBuilder, abilityComponent, typeTooltip);
        }
        addHeader = true;
        for (DataComponentType type : BetterTrimsRegistries.TRIM_ITEM_PROPERTY_COMPONENT_TYPE) {
            castType = type;
            CompositeContainerComponent itemPropertyComponent = this.generateItemPropertyTooltipComponent(level, font, (DataComponentType<List<ConditionalElement<TrimElement>>>)castType);
            if (itemPropertyComponent == null) continue;
            if (hasAbilities) {
                pageBuilder.space();
            }
            if (addHeader) {
                pageBuilder.component(TrimTooltipPage.generateAsItemHeader());
                addHeader = false;
            }
            typeTooltip = TrimItemPropertyComponents.TOOLTIPS.get(BetterTrimsRegistries.TRIM_ITEM_PROPERTY_COMPONENT_TYPE.getKey((Object)type));
            this.generateElementComponent(pageBuilder, itemPropertyComponent, typeTooltip);
        }
        CompositeContainerComponent page = pageBuilder.build();
        this.component = TooltipComponentOptimiser.optimise(page, font);
    }

    private void generateElementComponent(CompositeContainerComponent.Builder pageBuilder, CompositeContainerComponent elementComponent, Component typeTooltip) {
        if (typeTooltip == null) {
            typeTooltip = Component.translatable((String)"bettertrims.tooltip.component.unknown");
        }
        CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder().vertical().component(CompositeContainerComponent.builder().space().textComponent((Component)Styler.component(typeTooltip.copy())).build());
        if (!elementComponent.isEmpty()) {
            builder.component(CompositeContainerComponent.builder().space().space().component(elementComponent).build());
        }
        pageBuilder.component(builder.build());
    }

    public int getRenderedWidth(Font font) {
        return DynamicWidthComponent.getMaxWidth(font, this.component, 0);
    }

    private ClientTooltipComponent generateTitle(ClientLevel level, int index, int total) {
        ResourceLocation propertyId = VRegistry.get(level, BetterTrimsRegistries.Keys.TRIM_PROPERTIES).getKey((Object)this.property);
        if (propertyId == null) {
            BetterTrims.LOGGER.warn("Property {} does not have a registry name", (Object)this.property);
            propertyId = BetterTrims.rl("unknown");
        }
        CompositeContainerComponent.Builder builder = ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.property.%s.%s".formatted(propertyId.getNamespace(), propertyId.getPath()), Styler::trim, new Object[0])).space().literal("(", Styler::trim)).component(TrimTooltipPage.generateMatcherComponent(level, this.matcher.material(), this.matcher.pattern())).literal(")", Styler::trim)).centred(true);
        if (total > 1) {
            builder.literal(" - [" + (index + 1) + "/" + total + "]", Styler::trim);
        }
        return builder.build();
    }

    private CompositeContainerComponent generateAbilityTooltipComponent(ClientLevel level, Font font, DataComponentType<List<ConditionalElement<TrimElement>>> type) {
        List<ConditionalElementMatcher<?>> elements = this.property.getAbilityElements(type);
        if (elements.isEmpty()) {
            return null;
        }
        CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder().vertical();
        for (ConditionalElementMatcher<?> element : elements) {
            builder.component(this.getTooltipFromConditionalElement(level, font, element.getConditionalElement()));
        }
        return builder.build();
    }

    private CompositeContainerComponent generateItemPropertyTooltipComponent(ClientLevel level, Font font, DataComponentType<List<ConditionalElement<TrimElement>>> castType) {
        List<ConditionalElementMatcher<?>> elements = this.property.getItemPropertyElements(castType);
        if (elements.isEmpty()) {
            return null;
        }
        CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder().vertical();
        for (ConditionalElementMatcher<?> element : elements) {
            builder.component(this.getTooltipFromConditionalElement(level, font, element.getConditionalElement()));
        }
        return builder.build();
    }

    private ClientTooltipComponent getTooltipFromConditionalElement(ClientLevel level, Font font, ConditionalElement<?> conditionalElement) {
        Object element = conditionalElement.element();
        Optional<LootItemCondition> requirements = conditionalElement.requirements();
        CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder().vertical();
        requirements.map(condition -> LootConditionTooltips.getTooltip(level, font, condition)).ifPresent(builder::component);
        TrimElementTooltipProvider<TrimElement> provider = TrimElementTooltips.getProvider(element.getClass());
        ClientTooltipComponent tooltip = provider.getTooltip(level, (TrimElement)element, true);
        if (tooltip != null) {
            builder.component(tooltip);
        }
        return builder.build();
    }

    private ClientTooltipComponent generateWearingAbilityHeader(ClientLevel level) {
        HolderSet.Direct patterns;
        int minCount = this.matcher.minCount();
        ArrayList<CyclingComponent> trimmedItems = new ArrayList<CyclingComponent>();
        HolderSet.Direct materials = this.matcher.material();
        if (materials.size() == 0) {
            materials = HolderSet.direct(TrimTooltipPage.getAllMaterialProviders(level).stream().map(stack -> Holder.direct((Object)VTrims.getMaterialFromStack(level, stack))).toList());
        }
        if ((patterns = this.matcher.pattern()).size() == 0) {
            patterns = HolderSet.direct(BetterTrimsClient.getPatternSources().keySet().stream().toList());
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        for (Holder material : materials) {
            for (Object pattern : patterns) {
                pairs.add(Pair.of((Object)pattern, (Object)material));
            }
        }
        for (Pair pair : pairs) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (Item item : List.of(Items.IRON_HELMET, Items.IRON_CHESTPLATE, Items.IRON_LEGGINGS, Items.IRON_BOOTS)) {
                ArmorTrim trim = new ArmorTrim((Holder)pair.right(), (Holder)pair.left());
                ItemStack stack2 = item.getDefaultInstance();
                stack2.set(DataComponents.TRIM, (Object)trim);
                items.add(stack2);
            }
            CyclingComponent.Builder builder2 = CyclingComponent.builder();
            items.stream().map(ItemComponent::new).forEach(builder2::component);
            trimmedItems.add(builder2.build());
        }
        return switch (minCount) {
            case 4 -> ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.properties.count.all_of", Styler::normal, new Object[0])).stack(trimmedItems, 16).translate("bettertrims.tooltip.properties.count.equipped", Styler::normal, new Object[0])).spaced().centred(true).build();
            case 1 -> ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.properties.count.any_of", Styler::normal, new Object[0])).cycle(builder -> trimmedItems.stream().flatMap(cycler -> cycler.getComponents().stream()).forEach(builder::component)).translate("bettertrims.tooltip.properties.count.equipped", Styler::normal, new Object[0])).spaced().centred(true).build();
            default -> ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.properties.count.n_of", Styler::normal, new Object[]{minCount})).stack(trimmedItems, 16).translate("bettertrims.tooltip.properties.count.equipped", Styler::normal, new Object[0])).spaced().centred(true).build();
        };
    }
}

