/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.component;

import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import org.jetbrains.annotations.NotNull;

public record StackedComponent(List<? extends ClientTooltipComponent> components, int offset) implements ClientTooltipComponent
{
    public StackedComponent(List<? extends ClientTooltipComponent> components, int offset) {
        this.components = components.reversed();
        this.offset = offset;
    }

    public int getHeight(Font font) {
        return 16;
    }

    public int getWidth(Font font) {
        return Math.max(16, 16 - this.offset + this.offset * this.components.size());
    }

    public void renderImage(Font font, int x, int y, int width, int height, GuiGraphics graphics) {
        if (this.components.isEmpty()) {
            return;
        }
        int currentOffset = this.components.size() - 1;
        for (ClientTooltipComponent clientTooltipComponent : this.components) {
            clientTooltipComponent.renderImage(font, x + this.offset * currentOffset, y, width, height, graphics);
            --currentOffset;
        }
    }

    public void renderText(GuiGraphics guiGraphics, Font font, int x, int y) {
        if (this.components.isEmpty()) {
            return;
        }
        int currentOffset = this.components.size() - 1;
        for (ClientTooltipComponent clientTooltipComponent : this.components) {
            clientTooltipComponent.renderText(guiGraphics, font, x + this.offset * currentOffset, y);
            --currentOffset;
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "StackedComponent{%s}".formatted(this.components);
    }
}

