/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeBuilder;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.ExactDataComponentPredicateTooltipAdders;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.PartialDataComponentPredicateTooltipAdders;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.predicates.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public interface DataComponentMatchersTooltip {
    public static void addToBuilder(ClientLevel level, DataComponentMatchers components, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Map partial;
        if (components.isEmpty()) {
            builder.translate(DataComponentMatchersTooltip.key("any"), Styler::condition, new Object[0]);
            return;
        }
        DataComponentExactPredicate exact = components.exact();
        if (!exact.isEmpty()) {
            DataComponentMatchersTooltip.addDataComponentExactPredicateToBuilder(level, exact, state, builder);
        }
        if (!(partial = components.partial()).isEmpty()) {
            DataComponentMatchersTooltip.addPartialDataComponentPredicatesToBuilder(level, partial, state, builder);
        }
    }

    public static String key(String key) {
        return PredicateTooltip.key("data.%s".formatted(key));
    }

    public static void addDataComponentExactPredicateToBuilder(ClientLevel level, DataComponentExactPredicate exact, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Set entries = exact.asPatch().entrySet();
        if (entries.isEmpty()) {
            builder.translate(DataComponentMatchersTooltip.key("exact.any"), Styler::condition, new Object[0]);
        } else if (entries.size() == 1) {
            Map.Entry entry = (Map.Entry)entries.iterator().next();
            Optional value = (Optional)entry.getValue();
            if (value.isEmpty()) {
                ResourceLocation key = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)((DataComponentType)entry.getKey()));
                if (key != null) {
                    builder.translate(DataComponentMatchersTooltip.key("exact.any_for_type"), Styler::condition, new Object[]{Styler.property(Component.literal((String)key.toString()))});
                } else {
                    builder.translate(DataComponentMatchersTooltip.key("unknown"), Styler::condition, new Object[0]);
                }
                return;
            }
            ExactDataComponentPredicateTooltipAdders.addToBuilder(level, (DataComponentType)entry.getKey(), ((Optional)entry.getValue()).orElseThrow(), state, builder);
        } else {
            CompositeBuilder listBuilder = CompositeContainerComponent.builder().vertical().literal(":", Styler::condition);
            for (Map.Entry entry : entries) {
                Optional value = (Optional)entry.getValue();
                CompositeBuilder termBuilder = CompositeContainerComponent.builder().space().literal("\u2022 ", Styler::condition);
                if (value.isEmpty()) {
                    ResourceLocation key = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)((DataComponentType)entry.getKey()));
                    if (key != null) {
                        ((CompositeContainerComponent.Builder)termBuilder).translate(DataComponentMatchersTooltip.key("exact.any_for_type"), Styler::condition, new Object[]{Styler.property(Component.literal((String)key.toString()))});
                    } else {
                        ((CompositeContainerComponent.Builder)termBuilder).translate(DataComponentMatchersTooltip.key("unknown"), Styler::condition, new Object[0]);
                    }
                } else {
                    ExactDataComponentPredicateTooltipAdders.addToBuilder(level, (DataComponentType)entry.getKey(), ((Optional)entry.getValue()).orElse(null), state, (CompositeContainerComponent.Builder)termBuilder);
                }
                ((CompositeContainerComponent.Builder)listBuilder).component(((CompositeContainerComponent.Builder)termBuilder).build());
            }
            builder.component(((CompositeContainerComponent.Builder)listBuilder).build());
        }
    }

    public static void addPartialDataComponentPredicatesToBuilder(ClientLevel level, Map<DataComponentPredicate.Type<?>, DataComponentPredicate> partial, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        if (partial.isEmpty()) {
            builder.translate(DataComponentMatchersTooltip.key("unknown"), new Object[0]);
        } else if (partial.size() == 1) {
            Map.Entry<DataComponentPredicate.Type<?>, DataComponentPredicate> entry = partial.entrySet().iterator().next();
            PartialDataComponentPredicateTooltipAdders.addToBuilder(level, entry.getKey(), entry.getValue(), state, builder);
        } else {
            CompositeBuilder listBuilder = CompositeContainerComponent.builder().vertical().literal(":", Styler::condition);
            for (Map.Entry<DataComponentPredicate.Type<?>, DataComponentPredicate> entry : partial.entrySet()) {
                CompositeBuilder termBuilder = CompositeContainerComponent.builder().space().literal("\u2022 ", Styler::condition);
                PartialDataComponentPredicateTooltipAdders.addToBuilder(level, entry.getKey(), entry.getValue(), state, builder);
                ((CompositeContainerComponent.Builder)listBuilder).component(((CompositeContainerComponent.Builder)termBuilder).build());
            }
            builder.component(((CompositeContainerComponent.Builder)listBuilder).build());
        }
    }
}

