/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.mixin.property.ability.targeting;

import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.type.misc.PiglinSafeAbility;
import com.bawnorton.bettertrims.property.context.TrimContexts;
import com.bawnorton.bettertrims.property.element.ElementMatcher;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.sensing.PiglinSpecificSensor;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={PiglinSpecificSensor.class})
abstract class PiglinSpecificSensorMixin {
    PiglinSpecificSensorMixin() {
    }

    @WrapOperation(method={"doTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/piglin/PiglinAi;isWearingSafeArmor(Lnet/minecraft/world/entity/LivingEntity;)Z")})
    private static boolean isWearingSafeTrim(LivingEntity target, Operation<Boolean> original, ServerLevel level, LivingEntity entity) {
        boolean wearingSafeArmour = (Boolean)original.call(new Object[]{target});
        if (wearingSafeArmour) {
            return true;
        }
        for (TrimProperty property : TrimProperties.getProperties((Level)level)) {
            for (ElementMatcher elementMatcher : property.getAbilityElements(TrimAbilityComponents.PIGLIN_SAFE)) {
                Object t = elementMatcher.getElement();
                if (!(t instanceof PiglinSafeAbility)) continue;
                PiglinSafeAbility piglinSafeAbility = (PiglinSafeAbility)t;
                if (!elementMatcher.matches(target, TrimContexts.entity(level, elementMatcher.getMatchingItems(target), (Entity)entity, entity.position())) || !piglinSafeAbility.entityLooksForGold(entity)) continue;
                return true;
            }
        }
        return false;
    }
}

