/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.ability.type;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.property.AllOf;
import com.bawnorton.bettertrims.property.ability.type.value.AddValue;
import com.bawnorton.bettertrims.property.ability.type.value.MultiplyValue;
import com.bawnorton.bettertrims.property.ability.type.value.RemoveBinomial;
import com.bawnorton.bettertrims.property.ability.type.value.SetValue;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.bawnorton.bettertrims.property.element.TrimElement;
import com.bawnorton.bettertrims.registry.BetterTrimsRegistries;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public interface TrimValueAbility
extends TrimElement {
    public static final Codec<TrimValueAbility> CODEC = BetterTrimsRegistries.TRIM_VALUE_ABILITY_TYPE.byNameCodec().dispatch(TrimValueAbility::codec, Function.identity());

    public static MapCodec<? extends TrimValueAbility> bootstrap(Registry<MapCodec<? extends TrimValueAbility>> registry) {
        Registry.register(registry, (ResourceLocation)BetterTrims.rl("add"), AddValue.CODEC);
        Registry.register(registry, (ResourceLocation)BetterTrims.rl("all_of"), AllOf.ValueAbilities.CODEC);
        Registry.register(registry, (ResourceLocation)BetterTrims.rl("multiply"), MultiplyValue.CODEC);
        Registry.register(registry, (ResourceLocation)BetterTrims.rl("remove_binomial"), RemoveBinomial.CODEC);
        return (MapCodec)Registry.register(registry, (ResourceLocation)BetterTrims.rl("set"), SetValue.CODEC);
    }

    public static AddValue add(CountBasedValue value) {
        return new AddValue(value);
    }

    public static MultiplyValue multiply(CountBasedValue value) {
        return new MultiplyValue(value);
    }

    public static RemoveBinomial removeBinomial(CountBasedValue chance) {
        return new RemoveBinomial(chance);
    }

    public static SetValue set(CountBasedValue value) {
        return new SetValue(value);
    }

    public float process(int var1, RandomSource var2, float var3);

    @Override
    default public boolean usesCount() {
        return true;
    }

    public MapCodec<? extends TrimValueAbility> codec();
}

