/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record DimensionCheck(HolderSet<DimensionType> dimensions) implements LootItemCondition
{
    public static final MapCodec<DimensionCheck> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.DIMENSION_TYPE).fieldOf("dimensions").forGetter(DimensionCheck::dimensions)).apply((Applicative)instance, DimensionCheck::new));
    public static LootItemConditionType TYPE;

    public static Builder of(HolderSet<DimensionType> dimensions) {
        return new Builder(dimensions);
    }

    @NotNull
    public LootItemConditionType getType() {
        return TYPE;
    }

    public boolean test(LootContext context) {
        return this.dimensions().contains(context.getLevel().dimensionTypeRegistration());
    }

    public record Builder(HolderSet<DimensionType> dimensions) implements LootItemCondition.Builder
    {
        @NotNull
        public LootItemCondition build() {
            return new DimensionCheck(this.dimensions);
        }
    }
}

