/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.element;

import com.bawnorton.bettertrims.property.Matcher;
import com.bawnorton.bettertrims.property.context.ContextChecker;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.property.element.TrimElement;
import com.google.common.base.Predicates;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;

public class ElementMatcher<T extends TrimElement>
implements ContextChecker {
    private final Matcher matcher;
    private final T element;

    public ElementMatcher(Matcher matcher, T element) {
        this.matcher = matcher;
        this.element = element;
    }

    public T getElement() {
        return this.element;
    }

    @Override
    public Predicate<LootContext> conditionChecker() {
        return Predicates.alwaysTrue();
    }

    public boolean matches(ItemStack stack, LootContext context) {
        return this.matcher.matches(stack) && this.checkRequirement(context);
    }

    public boolean matches(LivingEntity wearer, LootContext context) {
        return this.matcher.getMatchingStacks(wearer).size() >= this.matcher.minCount() && this.checkRequirement(context);
    }

    public TrimmedItems getMatchingItems(LivingEntity wearer) {
        Map<EquipmentSlot, ItemStack> matchingStacks = this.matcher.getMatchingStacks(wearer);
        return TrimmedItems.of(matchingStacks, wearer);
    }
}

