/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.registry;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.ability.type.TrimToggleAbility;
import com.bawnorton.bettertrims.property.ability.type.TrimValueAbility;
import com.bawnorton.bettertrims.property.count.CountBasedValueTypes;
import com.bawnorton.bettertrims.property.item.TrimItemPropertyComponents;
import com.bawnorton.bettertrims.property.item.type.TrimItemProperty;
import com.bawnorton.bettertrims.registry.BetterTrimsAttributes;
import com.google.common.collect.Maps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class BetterTrimsRegistries {
    private static final Map<ResourceLocation, Supplier<?>> LOADERS = Maps.newLinkedHashMap();
    public static final Registry<DataComponentType<?>> TRIM_ABILITY_COMPONENT_TYPE = BetterTrimsRegistries.createRegistry(Keys.TRIM_ABILITY_COMPONENT_TYPE, TrimAbilityComponents::bootstrap);
    public static final Registry<DataComponentType<?>> TRIM_ITEM_PROPERTY_COMPONENT_TYPE = BetterTrimsRegistries.createRegistry(Keys.TRIM_ITEM_PROPERTY_COMPONENT_TYPE, TrimItemPropertyComponents::bootstrap);
    public static final Registry<MapCodec<? extends TrimToggleAbility>> TRIM_TOGGLE_ABILITY_TYPE = BetterTrimsRegistries.createRegistry(Keys.TRIM_TOGGLE_ABILITY_TYPE, TrimToggleAbility::bootstrap);
    public static final Registry<MapCodec<? extends TrimValueAbility>> TRIM_VALUE_ABILITY_TYPE = BetterTrimsRegistries.createRegistry(Keys.TRIM_VALUE_ABILITY_TYPE, TrimValueAbility::bootstrap);
    public static final Registry<MapCodec<? extends TrimEntityAbility>> TRIM_ENTITY_ABILITY_TYPE = BetterTrimsRegistries.createRegistry(Keys.TRIM_ENTITY_ABILITY_TYPE, TrimEntityAbility::bootstrap);
    public static final Registry<MapCodec<? extends TrimItemProperty>> TRIM_ITEM_PROPERTY_TYPES = BetterTrimsRegistries.createRegistry(Keys.TRIM_ITEM_PROPERTY_TYPES, TrimItemProperty::bootstrap);

    private static <T> Registry<T> createRegistry(ResourceKey<Registry<T>> key, Function<Registry<T>, Object> bootstrap) {
        MappedRegistry registry = new MappedRegistry(key, Lifecycle.stable());
        LOADERS.put(key.location(), () -> BetterTrimsRegistries.lambda$createRegistry$0(bootstrap, (Registry)registry));
        return registry;
    }

    public static void createContents() {
        CountBasedValueTypes.init();
        BetterTrimsAttributes.init();
        LOADERS.forEach((key, supplier) -> {
            if (supplier.get() == null) {
                BetterTrims.LOGGER.error("Unable to bootstrap registry '{}'", key);
            }
        });
    }

    private static /* synthetic */ Object lambda$createRegistry$0(Function bootstrap, Registry registry) {
        return bootstrap.apply(registry);
    }

    public static class Keys {
        public static final ResourceKey<Registry<TrimProperty>> TRIM_PROPERTIES = Keys.createRegistryKey("trim_properties");
        public static final ResourceKey<Registry<DataComponentType<?>>> TRIM_ABILITY_COMPONENT_TYPE = Keys.createRegistryKey("trim_ability_component_type");
        public static final ResourceKey<Registry<DataComponentType<?>>> TRIM_ITEM_PROPERTY_COMPONENT_TYPE = Keys.createRegistryKey("trim_item_property_component_type");
        public static final ResourceKey<Registry<MapCodec<? extends TrimToggleAbility>>> TRIM_TOGGLE_ABILITY_TYPE = Keys.createRegistryKey("trim_toggle_ability_type");
        public static final ResourceKey<Registry<MapCodec<? extends TrimValueAbility>>> TRIM_VALUE_ABILITY_TYPE = Keys.createRegistryKey("trim_value_ability_type");
        public static final ResourceKey<Registry<MapCodec<? extends TrimEntityAbility>>> TRIM_ENTITY_ABILITY_TYPE = Keys.createRegistryKey("trim_entity_ability_type");
        public static final ResourceKey<Registry<MapCodec<? extends TrimItemProperty>>> TRIM_ITEM_PROPERTY_TYPES = Keys.createRegistryKey("item_property_type");

        private static <T> ResourceKey<Registry<T>> createRegistryKey(String name) {
            return ResourceKey.createRegistryKey((ResourceLocation)BetterTrims.rl(name));
        }
    }
}

