package com.bawnorton.bettertrims;

import com.bawnorton.bettertrims.networking.Networking;
import com.bawnorton.configurable.Configurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

//? if fabric {
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
//?}
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public final class BetterTrims {
	public static final String MOD_ID = "bettertrims";
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

	public static final class_2960 DEFAULT = BetterTrims.rl("default");
	public static final class_2960 TRIM_EFFECTS = BetterTrims.rl("trim_effects");

	@Configurable
	public static boolean debug = false;

	public static void init() {
		Networking.init();
		LOGGER.debug("{} Initialized", MOD_ID);
		//? if fabric {
		ResourceManagerHelper.registerBuiltinResourcePack(
				TRIM_EFFECTS,
				FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow(),
				class_2561.method_43471("bettertrims.resourcepack.effects"),
				ResourcePackActivationType.NORMAL
		);

		ResourceManagerHelper.registerBuiltinResourcePack(
				DEFAULT,
				FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow(),
				class_2561.method_43471("bettertrims.resourcepack.default"),
				ResourcePackActivationType.DEFAULT_ENABLED
		);
		//?}
	}

	public static class_2960 rl(String path) {
		return class_2960.method_60655(MOD_ID, path);
	}
}
