package com.bawnorton.bettertrims.client.tooltip.component;

import java.util.List;
import net.minecraft.class_327;
import net.minecraft.class_5684;

public interface CompositeComponent extends DynamicWidthComponent {
	List<class_5684> getComponents();

	default int getMaxWidth(class_327 font) {
		int maxWidth = 0;
		for (class_5684 component : getComponents()) {
			maxWidth = DynamicWidthComponent.getMaxWidth(font, component, maxWidth);
		}
		return maxWidth;
	}

	default int getMinWidth(class_327 font) {
		int minWidth = Integer.MAX_VALUE;
		for (class_5684 component : getComponents()) {
			minWidth = DynamicWidthComponent.getMinWidth(font, component, minWidth);
		}
		return minWidth;
	}

	default boolean isOneLine() {
		for (class_5684 component : getComponents()) {
			if (component instanceof CompositeComponent composite) {
				if (composite.isOneLine()) continue;

				return false;
			}
		}
		return true;
	}
}
