package com.bawnorton.bettertrims.client.tooltip.condition;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.client.mixin.accessor.CompositeLootItemConditionAccessor;
import com.bawnorton.bettertrims.client.mixin.accessor.IntRangeAccessor;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.component.ConditionalComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.BlockPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.DamageSourcePredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.EntityPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.ItemPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.LocationPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Formatter;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.condition.DimensionCheck;
import com.bawnorton.bettertrims.util.TriState;
import com.bawnorton.bettertrims.version.VRegistry;
import net.minecraft.class_156;
import net.minecraft.class_182;
import net.minecraft.class_186;
import net.minecraft.class_1887;
import net.minecraft.class_190;
import net.minecraft.class_199;
import net.minecraft.class_201;
import net.minecraft.class_2022;
import net.minecraft.class_2048;
import net.minecraft.class_205;
import net.minecraft.class_207;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_212;
import net.minecraft.class_215;
import net.minecraft.class_217;
import net.minecraft.class_219;
import net.minecraft.class_221;
import net.minecraft.class_223;
import net.minecraft.class_2248;
import net.minecraft.class_225;
import net.minecraft.class_227;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_42;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_4568;
import net.minecraft.class_4571;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_5342;
import net.minecraft.class_5644;
import net.minecraft.class_5658;
import net.minecraft.class_5683;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8548;
import net.minecraft.class_9752;
import net.minecraft.world.level.storage.loot.predicates.*;
import org.jetbrains.annotations.NotNull;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public interface LootConditionTooltips {
	static CompositeContainerComponent getTooltip(class_638 level, class_327 font, class_5341 condition) {

		State state = new State();
		CompositeContainerComponent.Builder conditionBuilder = CompositeContainerComponent.builder();
		addConditionToTooltip(level, condition, conditionBuilder, state);
		CompositeContainerComponent conditionComponent = conditionBuilder.build();

		CompositeContainerComponent.Builder root = CompositeContainerComponent.builder();
		if (state.doUseIf()) {
			root.translate("bettertrims.tooltip.condition.if", Styler::condition)
					.space();
		}

		if (conditionComponent.isOneLine()) {
			return root.component(conditionComponent).build();
		} else {
			return root.component(CompositeContainerComponent.builder().component(new ConditionalComponent(
					new class_5683(Styler.condition(class_2561.method_43469(
							"bettertrims.tooltip.condition.hold_shift",
							Styler.trim(class_2561.method_43470("[LSHFT]"))
					)).method_30937()),
					conditionComponent,
					//? if >=1.21.10 {
					() -> !class_310.method_1551().method_74187() && !BetterTrims.debug
					//?} else {
					/*() -> !Screen.hasShiftDown() && !BetterTrims.debug
					*///?}
			)).build()).build();
		}
	}

	@SuppressWarnings("unchecked")
	private static void addConditionToTooltip(class_638 level, class_5341 condition, CompositeContainerComponent.Builder builder, State state) {
		LootTooltipAdder<class_5341> factory = (LootTooltipAdder<class_5341>) TOOLTIPS.getOrDefault(condition.method_29325(), LootTooltipAdder.EMPTY);
		factory.addToBuilder(level, condition, builder, state);
	}

	private static @NotNull List<class_2561> numberCompFromNumberProvider(class_5658 numberProvider, Function<Float, class_5250> valueFormatter, UnaryOperator<class_2561> literalFormatter) {
		return switch (numberProvider) {
			case ConstantValue constant -> List.of(Styler.number(valueFormatter.apply(constant.value())));
			case ScoreboardValue scoreboardValue -> {
				Component score = Styler.property(Component.literal(scoreboardValue.score()));
				Component targetComp = Styler.name(switch (scoreboardValue.target()) {
					case FixedScoreboardNameProvider fixed -> Component.literal(fixed.name());
					case ContextScoreboardNameProvider context ->
							Component.translatable("bettertrims.tooltip.condition.context_scoreboard_name.%s".formatted(context.target().getSerializedName()));
					default -> Component.literal("[?]");
				});
				yield List.of(Styler.condition(literalFormatter.apply(Component.translatable("bettertrims.tooltip.condition.number_provider.scoreboard", targetComp, score))
						.copy()));
			}
			case EnchantmentLevelProvider levelProvider -> {
				List<Component> components = new ArrayList<>();
				for (int i = 1; i <= 5; i++) {
					float value = levelProvider.amount().calculate(i);
					MutableComponent formattedValue = valueFormatter.apply(value);
					MutableComponent enchantmentLevelComp = Styler.value(Component.translatable("enchantment.level." + i));
					components.add(enchantmentLevelComp.append(": ").append(Styler.number(formattedValue)));
				}
				yield components;
			}
			case StorageValue storageValue -> {
				Component pathComp = Styler.value(Component.literal(storageValue.path().asString()));
				Component storageComp = Styler.name(Component.literal(storageValue.storage().toString()));
				yield List.of(literalFormatter.apply(Component.translatable("bettertrims.tooltip.condition.number_provider.storage", pathComp, storageComp)));
			}
			default -> List.of(Component.translatable("bettertrims.tooltip.condition.number_provider.complex"));
		};
	}

	interface LootTooltipAdder<T extends class_5341> {
		LootTooltipAdder<?> EMPTY = (level, condition, builder, state) -> builder.translate(
				"bettertrims.tooltip.condition.unknown",
				Styler::condition,
				Objects.requireNonNullElse(class_7923.field_41135.method_10221(condition.method_29325()), "[unregistered]").toString()
		);

		void addToBuilder(class_638 level, T condition, CompositeContainerComponent.Builder builder, State state);
	}

	Map<class_5342, LootTooltipAdder<?>> TOOLTIPS = class_156.method_654(
			new HashMap<>(), map -> {
				map.put(
						class_217.field_25235, (class_638 level, class_207 condition, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							class_5341 term = condition.comp_1873();
							CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
							addConditionToTooltip(level, term, builder, state.withInverted(!state.doInvert()));
							parentBuilder.component(builder.build());
						}
				);

				LootTooltipAdder<class_186> compositeFactory = (class_638 level, class_186 condition, CompositeContainerComponent.Builder parentBuilder, State state) -> {
					CompositeLootItemConditionAccessor composite = (CompositeLootItemConditionAccessor) condition;
					CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder().translate(
							"bettertrims.tooltip.condition.%s.%s".formatted(
									condition instanceof class_8548 ? "all_of" : "any_of",
									state.key()
							), Styler::condition
					).vertical();
					for (class_5341 term : composite.bettertrims$terms()) {
						CompositeContainerComponent.Builder termBuilder = CompositeContainerComponent.builder().literal("• ", Styler::condition);
						addConditionToTooltip(level, term, termBuilder, state.withInverted(false));
						builder.component(termBuilder.build());
					}
					parentBuilder.component(builder.build());
				};

				map.put(class_217.field_44789, compositeFactory);
				map.put(class_217.field_44790, compositeFactory);

				map.put(
						class_217.field_25237, (level, condition, parentBuilder, state) -> {
							class_219 chanceCondition = (class_219) condition;
							parentBuilder.cycle(chanceCycler -> {
								numberCompFromNumberProvider(
										chanceCondition.comp_2781(), value -> {
											if (state.doInvert()) {
												value = 1 - value;
											}
											return Formatter.percentage(value);
										}, comp -> comp.method_27661().method_27693("%")
								).forEach(numberComp -> {
									class_2561 tooltip = Styler.condition(class_2561.method_43469("bettertrims.tooltip.condition.random_chance", numberComp));
									chanceCycler.textComponent(tooltip);
								});
							});
							state.withUseIf(false);
						}
				);

				map.put(
						class_217.field_51811,
						(class_638 level, class_225 condition, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							class_2378<class_1887> registry = VRegistry.get(level, class_7924.field_41265);
							class_1887 enchantment = condition.comp_2783().method_40229().map(registry::method_31140, Function.identity());
							Map<Integer, Float> chanceMap = new HashMap<>();
							for (int i = 1; i <= enchantment.method_8183(); i++) {
								chanceMap.put(i, condition.comp_2866().method_60188(i));
							}
							class_2561 enchantmentName = Styler.name(enchantment.comp_2686().method_27661());
							parentBuilder.component(CompositeContainerComponent.builder()
									.translate("bettertrims.tooltip.condition.random_chance_with_enchanted_bonus.enchanted.%s".formatted(state.key()), Styler::condition, enchantmentName)
									.space()
									.cycle(levelCycler -> chanceMap.forEach((enchantLevel, chance) -> {
										class_5250 levelComp = Styler.value(class_2561.method_43471("enchantment.level." + enchantLevel)).method_27693(": ");
										class_5250 chanceComp = Styler.number(Formatter.percentage(chance));
										levelCycler.textComponent(levelComp.method_10852(chanceComp));
									}))
									.literal(",")
									.space()
									.translate(
											"bettertrims.tooltip.condition.random_chance_with_enchanted_bonus.else",
											Styler::condition,
											Styler.number(Formatter.percentage(condition.comp_2865()))
									)
									.build());
						}
				);

				map.put(
						class_217.field_25239,
						(class_638 level, class_215 condition, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							Optional<class_2048> predicate = condition.comp_1879();
							if (predicate.isEmpty()) return;

							class_2561 target = Styler.target(class_2561.method_43471("bettertrims.tooltip.condition.entity_properties.%s.%s".formatted(
									state.key(),
									condition.comp_1880().method_15434()
							)));
							CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder().vertical();
							EntityPredicateTooltip.addToBuilder(level, predicate.orElseThrow(), state, builder);
							parentBuilder.textComponent(target).component(builder.build());
						}
				);

				map.put(
						class_217.field_25240,
						(class_638 level, class_221 condition, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							parentBuilder.textComponent(Styler.condition(class_2561.method_43471("bettertrims.tooltip.condition.killed_by_player.%s".formatted(state.key()))));
						}
				);

				map.put(
						class_217.field_25241, (class_638 level, class_199 condition, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							class_2561 target = Styler.target(class_2561.method_43471("bettertrims.tooltip.condition.entity_properties.%s.%s".formatted(
									state.key(),
									condition.comp_1872().method_15434()
							)));
							Map<String, class_42> scores = condition.comp_1871();
							CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
							builder.cycle(scoreCycler -> scores.forEach((score, range) -> {
								IntRangeAccessor accessor = (IntRangeAccessor) range;
								class_5658 min = accessor.bettertrims$min();
								class_5658 max = accessor.bettertrims$max();

								List<class_2561> minComps = min == null ? null : numberCompFromNumberProvider(min, Formatter::decimal, UnaryOperator.identity());
								List<class_2561> maxComps = max == null ? null : numberCompFromNumberProvider(max, Formatter::decimal, UnaryOperator.identity());
								class_2561 scoreComp = Styler.property(class_2561.method_43470(score));
								if (minComps != null && maxComps != null) {
									scoreCycler.textComponent(Styler.condition(class_2561.method_43469(
											"bettertrims.tooltip.condition.entity_scores.between.%s".formatted(state.key()),
											target,
											scoreComp,
											minComps,
											maxComps
									)));
								} else if (minComps != null) {
									scoreCycler.textComponent(Styler.condition(class_2561.method_43469(
											"bettertrims.tooltip.condition.entity_scores.at_least.%s".formatted(state.key()),
											target,
											scoreComp,
											minComps
									)));
								} else if (maxComps != null) {
									scoreCycler.textComponent(Styler.condition(class_2561.method_43469(
											"bettertrims.tooltip.condition.entity_scores.at_most.%s".formatted(state.key()),
											target,
											scoreComp,
											maxComps
									)));
								} else {
									scoreCycler.textComponent(Styler.condition(class_2561.method_43469(
											"bettertrims.tooltip.condition.entity_scores.any_value.%s".formatted(state.key()),
											target,
											scoreComp
									)));
								}
							}));
						}
				);

				map.put(
						class_217.field_25242,
						(class_638 level, class_212 condition, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							class_2378<class_2248> registry = VRegistry.get(level, class_7924.field_41254);
							class_6880<class_2248> block = condition.comp_1876();
							class_2561 blockName = Styler.name(block.method_40229().map(registry::method_31140, Function.identity()).method_9518());
							Optional<class_4559> properties = condition.comp_1877();
							class_2561 target;
							CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
							if (properties.isPresent()) {
								target = Styler.condition(class_2561.method_43469(
										"bettertrims.tooltip.condition.block_state_property.with_properties.%s".formatted(state.key()),
										blockName
								));
								builder.textComponent(target);
								BlockPredicateTooltip.addStatePropertiesPredicateToBuilder(level, properties.orElseThrow(), state, builder);
							} else {
								target = Styler.condition(class_2561.method_43469("bettertrims.tooltip.condition.block_state_property.%s".formatted(state.key()), blockName));
								builder.textComponent(target);
							}
							parentBuilder.component(builder.build());
						}
				);

				map.put(
						class_217.field_25243, (class_638 level, class_223 matchTool, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							Optional<class_2073> predicate = matchTool.comp_1884();
							if (predicate.isEmpty()) return;

							CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
							builder.translate("bettertrims.tooltip.condition.match_tool", Styler::target);
							ItemPredicateTooltip.addToBuilder(level, predicate.orElseThrow(), state, builder);
							parentBuilder.component(builder.build());
						}
				);

				map.put(
						class_217.field_25244, (class_638 level, class_182 condition, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							class_6880<class_1887> enchantment = condition.comp_1867();
							List<Float> values = condition.comp_1868();
							class_2378<class_1887> registry = VRegistry.get(level, class_7924.field_41265);
							class_2561 enchantmentName = Styler.name(enchantment.method_40229().map(registry::method_31140, Function.identity()).comp_2686().method_27661());
							CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
							builder.translate("bettertrims.tooltip.condition.table_bonus.%s".formatted(state.key()), Styler::condition, enchantmentName).space().cycle(cycler -> {
								for (int i = 0; i < values.size(); i++) {
									float value = values.get(i);
									class_5250 levelComp = Styler.value(class_2561.method_43471("enchantment.level." + (i + 1))).method_27693(": ");
									class_5250 valueComp = Styler.number(Formatter.decimal(value));
									cycler.textComponent(levelComp.method_10852(valueComp));
								}
							});
							parentBuilder.component(builder.build());
						}
				);

				map.put(
						class_217.field_25245, (class_638 level, class_201 condition, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							parentBuilder.textComponent(Styler.condition(class_2561.method_43471("bettertrims.tooltip.condition.survives_explosion.%s".formatted(state.key()))));
						}
				);

				map.put(
						class_217.field_25246,
						(class_638 level, class_190 condition, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							Optional<class_2022> predicate = condition.comp_1870();
							if (predicate.isEmpty()) return;

							CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
							builder.translate("bettertrims.tooltip.condition.damage_source_properties.%s".formatted(state.key()), Styler::condition);
							DamageSourcePredicateTooltip.addToBuilder(level, predicate.orElseThrow(), state, builder);
							parentBuilder.component(builder.build());
						}
				);

				map.put(
						class_217.field_25247, (class_638 level, class_205 locationCheck, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							Optional<class_2090> predicate = locationCheck.comp_1874();
							if (predicate.isEmpty()) return;

							class_2338 offset = locationCheck.comp_1875();
							CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
							LocationPredicateTooltip.addToBuilder(level, predicate.orElseThrow(), state, builder);
							if (!offset.equals(class_2338.field_10980)) {
								class_5250 offsetComp = Styler.value(class_2561.method_43470("(%d, %d, %d)".formatted(offset.method_10263(), offset.method_10264(), offset.method_10260())));
								builder.space().translate("bettertrims.tooltip.condition.location_check.offset", Styler::condition, offsetComp);
							}
							parentBuilder.component(builder.build());
						}
				);

				map.put(
						class_217.field_25248, (class_638 level, class_227 weatherCheck, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							Optional<Boolean> raining = weatherCheck.comp_1889();
							Optional<Boolean> thundering = weatherCheck.comp_1890();
							if (raining.isEmpty() && thundering.isEmpty()) return;

							CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
							if (raining.isPresent() && thundering.isPresent()) {
								builder.translate(
										"bettertrims.tooltip.condition.weather_check.both.%s".formatted(state.key()),
										Styler::condition,
										Styler.value(class_2561.method_43471("bettertrims.tooltip.condition.weather_check.raining.%s".formatted(raining.get() ? "true" : "false"))),
										Styler.value(class_2561.method_43471("bettertrims.tooltip.condition.weather_check.thundering.%s".formatted(thundering.get() ? "true" : "false")))
								);
							} else if (raining.isPresent()) {
								builder.translate(
										"bettertrims.tooltip.condition.weather_check.raining.%s".formatted(state.key()),
										Styler::condition,
										Styler.value(class_2561.method_43471("bettertrims.tooltip.condition.weather_check.raining.%s".formatted(raining.get() ? "true" : "false")))
								);
							} else {
								builder.translate(
										"bettertrims.tooltip.condition.weather_check.thundering.%s".formatted(state.key()),
										Styler::condition,
										Styler.value(class_2561.method_43471("bettertrims.tooltip.condition.weather_check.thundering.%s".formatted(thundering.get() ? "true" : "false")))
								);
							}
							parentBuilder.component(builder.build());
						}
				);

				map.put(
						class_217.field_25249, (class_638 level, class_4568 conditionReference, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							class_5321<class_5341> name = conditionReference.comp_1869();
							class_2960 id = name.method_29177();
							parentBuilder.textComponent(Styler.condition(class_2561.method_43469(
									"bettertrims.tooltip.condition.reference.%s".formatted(state.key()),
									Styler.name(class_2561.method_43470(id.toString()))
							)));
						}
				);

				map.put(
						class_217.field_25250, (class_638 level, class_4571 timeCheck, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							class_42 value = timeCheck.comp_1886();
							Optional<Long> period = timeCheck.comp_1885();
							IntRangeAccessor accessor = (IntRangeAccessor) value;
							class_5658 min = accessor.bettertrims$min();
							class_5658 max = accessor.bettertrims$max();

							Function<Float, class_5250> formatter = ticks -> {
								long totalSeconds = Math.round(ticks / 20) * 72L;
								long totalMinutes = TimeUnit.SECONDS.toMinutes(totalSeconds);
								long totalHours = TimeUnit.MINUTES.toHours(totalMinutes);
								long days = TimeUnit.HOURS.toDays(totalHours);
								long minutes = totalMinutes % 60;
								long hours = (totalHours + 6) % 24;
								String ampm = hours >= 12 ? "pm" : "am";
								hours = hours % 12;
								if (hours == 0) hours = 12;
								if (days > 0) {
									return class_2561.method_43470("%d:%02d%s + %d Days".formatted(hours, minutes, ampm, days));
								} else {
									return class_2561.method_43470("%d:%02d%s".formatted(hours, minutes, ampm));
								}
							};

							List<class_2561> minComps = min == null ? numberCompFromNumberProvider(new class_44(0), formatter, UnaryOperator.identity()) : numberCompFromNumberProvider(
									min,
									formatter,
									UnaryOperator.identity()
							);
							List<class_2561> maxComps = max == null ? numberCompFromNumberProvider(
									new class_44(24000),
									formatter,
									UnaryOperator.identity()
							) : numberCompFromNumberProvider(max, formatter, UnaryOperator.identity());
							CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
							builder.translate("bettertrims.tooltip.condition.time_check.%s".formatted(state.key()), Styler::condition)
									.space()
									.translate("bettertrims.tooltip.condition.time_check.between", Styler::condition)
									.space()
									.cycle(cycleBuilder -> minComps.forEach(cycleBuilder::textComponent))
									.literal(" & ", Styler::condition)
									.cycle(cycleBuilder -> maxComps.forEach(cycleBuilder::textComponent));
							if (period.isPresent()) {
								float periodTicks = period.orElseThrow();
								long totalSeconds = Math.round(periodTicks / 20) * 72L;
								long totalMinutes = TimeUnit.SECONDS.toMinutes(totalSeconds);
								long totalHours = TimeUnit.MINUTES.toHours(totalMinutes);
								long days = TimeUnit.HOURS.toDays(totalHours);
								long minutes = totalMinutes % 60;
								long hours = totalHours % 24;
								StringBuilder formattedPeriod = new StringBuilder();
								if (days > 0) {
									if (days == 1) {
										formattedPeriod.append("Day");
									} else {
										formattedPeriod.append("%d Days".formatted(days));
									}
								}
								if (hours > 0) {
									if (!formattedPeriod.isEmpty()) {
										formattedPeriod.append(", %d Hours".formatted(hours));
									} else if (hours == 1) {
										formattedPeriod.append("Hour");
									} else {
										formattedPeriod.append("%d Hours".formatted(hours));
									}
								}
								if (minutes > 0) {
									if (!formattedPeriod.isEmpty()) {
										formattedPeriod.append(", %d Minutes".formatted(minutes));
									} else if (minutes == 1) {
										formattedPeriod.append("Minute");
									} else {
										formattedPeriod.append("%d Minutes".formatted(minutes));
									}
								}
								if (formattedPeriod.isEmpty()) {
									formattedPeriod.append("%d Seconds".formatted(totalSeconds));
								}
								builder.space()
										.translate("bettertrims.tooltip.condition.time_check.period", Styler::condition, Styler.value(class_2561.method_43470(formattedPeriod.toString())));
							}
							parentBuilder.component(builder.build());
						}
				);

				map.put(
						class_217.field_27911, (class_638 level, class_5644 condition, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							class_5658 provider = condition.comp_1887();
							class_42 range = condition.comp_1888();
							IntRangeAccessor accessor = (IntRangeAccessor) range;
							class_5658 min = accessor.bettertrims$min();
							class_5658 max = accessor.bettertrims$max();
							List<class_2561> providerComps = numberCompFromNumberProvider(provider, Formatter::decimal, UnaryOperator.identity());
							List<class_2561> minComps = min == null ? null : numberCompFromNumberProvider(min, Formatter::decimal, UnaryOperator.identity());
							List<class_2561> maxComps = max == null ? null : numberCompFromNumberProvider(max, Formatter::decimal, UnaryOperator.identity());
							CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
							builder.translate("bettertrims.tooltip.condition.value_check.%s".formatted(state.key()), Styler::condition, providerComps).space();
							if (minComps != null && maxComps != null) {
								builder.translate("bettertrims.tooltip.condition.value_check.between", Styler::condition, minComps, maxComps);
							} else if (minComps != null) {
								builder.translate("bettertrims.tooltip.condition.value_check.at_least", Styler::condition, minComps);
							} else if (maxComps != null) {
								builder.translate("bettertrims.tooltip.condition.value_check.at_most", Styler::condition, maxComps);
							} else {
								builder.translate("bettertrims.tooltip.condition.value_check.any_value", Styler::condition);
							}
							parentBuilder.component(builder.build());
						}
				);

				map.put(
						class_217.field_51812,
						(class_638 level, class_9752 condition, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							parentBuilder.translate("bettertrims.tooltip.condition.enchantment_active_check.%s.%S".formatted(state.key(), condition.comp_2780()), Styler::condition);
						}
				);

				map.put(
						DimensionCheck.TYPE, (class_638 level, DimensionCheck condition, CompositeContainerComponent.Builder parentBuilder, State state) -> {
							class_6885<class_2874> dimensions = condition.dimensions();
							PredicateTooltip.addRegisteredElementsToBuilder(
									level,
									"bettertrims.tooltip.condition.dimension_check.%s".formatted(state.key()),
									class_7924.field_41241,
									dimensions,
									state.withPrefixSpace(false),
									parentBuilder
							);
						}
				);
			}
	);

	class State {
		private final Set<StateEntry> entries = new HashSet<>();
		private final StateEntry inverted = entry("inverted", false, true);
		private final StateEntry useWith = entry("with", false, true);
		private final StateEntry prefixSpace = entry("space", true, false);
		private final StateEntry useIf = entry("if", true, false);

		public static String normalKey() {
			return "normal";
		}

		private StateEntry entry(String key, boolean defaultValue, boolean includedInKey) {
			StateEntry stateEntry = new StateEntry(key, defaultValue, includedInKey);
			entries.add(stateEntry);
			return stateEntry;
		}

		public State withInverted(boolean inverted) {
			this.inverted.switchTo(inverted);
			return this;
		}

		public State withPrefixSpace(boolean prefixSpace) {
			this.prefixSpace.switchTo(prefixSpace);
			return this;
		}

		public State withUseWith(boolean useWith) {
			this.useWith.switchTo(useWith);
			return this;
		}

		public State withUseIf(boolean useIf) {
			this.useIf.switchTo(useIf);
			return this;
		}

		public boolean doInvert() {
			return inverted.value();
		}

		public boolean doPrefixSpace() {
			return prefixSpace.value();
		}

		public boolean doUseWith() {
			return useWith.value();
		}

		public boolean doUseIf() {
			return useIf.value();
		}

		public String key() {
			StringBuilder keyBuilder = new StringBuilder();
			for (StateEntry entry : entries) {
				if (entry.includedInKey() && entry.value()) {
					if (!keyBuilder.isEmpty()) {
						keyBuilder.append(".");
					}
					keyBuilder.append(entry.key());
				}
			}
			if (keyBuilder.isEmpty()) {
				return normalKey();
			}
			return keyBuilder.toString();
		}

		private static final class StateEntry {
			private final String key;
			private final boolean defaultValue;
			private final boolean includedInKey;
			private TriState state;

			private StateEntry(String key, boolean defaultValue, boolean includedInKey) {
				this.key = key;
				this.state = TriState.DEFAULT;
				this.defaultValue = defaultValue;
				this.includedInKey = includedInKey;
			}

			public void switchTo(boolean value) {
				state = value ? TriState.TRUE : TriState.FALSE;
			}

			public boolean value() {
				return state == TriState.DEFAULT ? defaultValue : state == TriState.TRUE;
			}

			public boolean includedInKey() {
				return includedInKey;
			}

			public String key() {
				return key;
			}
		}
	}


}
