package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.util.Formatter;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeBuilder;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.version.VRegistry;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2096;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_8129;

public interface PredicateTooltip {
	static String key(String key) {
		return "bettertrims.tooltip.condition.predicate.%s".formatted(key);
	}

	static void addMinMaxToBuilder(String key, boolean useAnd, class_2096<?> minMaxBounds, LootConditionTooltips.State state, CompositeBuilder<?> builder) {
		addMinMaxToBuilder(key, useAnd, minMaxBounds.method_74106().orElse(null), minMaxBounds.method_74107().orElse(null), state, builder);
	}

	static void addMinMaxToBuilder(String key, boolean useAnd, Number min, Number max, LootConditionTooltips.State state, CompositeBuilder<?> builder) {
		addMinMaxToBuilder(key, useAnd, min, max, Formatter::decimal, state, builder);
	}

	static void addMinMaxToBuilder(String key, boolean useAnd, class_2096<?> minMaxBounds, Function<Double, class_5250> formatter, LootConditionTooltips.State state, CompositeBuilder<?> builder) {
		addMinMaxToBuilder(key, useAnd, minMaxBounds.method_74106().orElse(null), minMaxBounds.method_74107().orElse(null), formatter, state, builder);
	}

	static void addMinMaxToBuilder(String key, boolean useAnd, Number min, Number max, Function<Double, class_5250> formatter, LootConditionTooltips.State state, CompositeBuilder<?> builder) {
		if (state.doPrefixSpace()) {
			builder.space();
		}
		if (useAnd) {
			builder.translate("bettertrims.tooltip.and", Styler::condition).space();
		}
		if (min != null && max != null) {
			if (min.equals(max)) {
				builder.translate("%s.is".formatted(key), Styler::condition, Styler.number(formatter.apply(min.doubleValue())));
			} else {
				builder.translate(
						"%s.between".formatted(key),
						Styler::condition,
						Styler.number(formatter.apply(min.doubleValue())),
						Styler.number(formatter.apply(max.doubleValue()))
				);
			}
		} else if (min != null) {
			builder.translate("%s.at_least".formatted(key), Styler::condition, Styler.number(formatter.apply(min.doubleValue())));
		} else if (max != null) {
			builder.translate("%s.at_most".formatted(key), Styler::condition, Styler.number(formatter.apply(max.doubleValue())));
		}
	}

	static <T> void addRegisteredElementsToBuilder(class_638 level, String key, class_5321<class_2378<T>> registryKey, class_6885<T> elements, LootConditionTooltips.State state, CompositeBuilder<?> builder) {
		addRegisteredElementsToBuilder(level, key, registryKey, elements, (Function<T, class_2561>) null, state, builder);
	}

	static <T> void addRegisteredElementsToBuilder(class_638 level, String key, class_5321<class_2378<T>> registryKey, class_6885<T> elements, Function<T, class_2561> nameMapper, LootConditionTooltips.State state, CompositeBuilder<?> builder) {
		addRegisteredElementsToBuilder(level, key, registryKey, elements, nameMapper == null ? null : (element, composite) -> nameMapper.apply(element), state, builder);
	}

	static <T> void addRegisteredElementsToBuilder(class_638 level, String key, class_5321<class_2378<T>> registryKey, class_6885<T> elements, BiFunction<T, CompositeBuilder<?>, class_2561> nameMapper, LootConditionTooltips.State state, CompositeBuilder<?> builder) {
		class_2378<T> registry = VRegistry.get(level, registryKey);
		CompositeContainerComponent.Builder registeredElementBuilder = CompositeContainerComponent.builder();
		if (state.doPrefixSpace()) {
			registeredElementBuilder.space();
		}
		registeredElementBuilder.translate(elements.method_40247() == 1 ? key : key + ".multiple", Styler::condition)
				.space()
				.cycle(cycler -> elements.method_40239().forEach(holder -> {
					if (nameMapper != null) {
						CompositeContainerComponent.Builder elementBuilder = CompositeContainerComponent.builder();
						class_2561 name = Styler.name(nameMapper.apply(holder.method_40229().map(registry::method_31140, Function.identity()), elementBuilder).method_27661());
						cycler.component(CompositeContainerComponent.builder().textComponent(name).component(elementBuilder.build()).build());
					} else {
						cycler.textComponent(Styler.name(class_2561.method_43470(holder.method_40229().map(class_5321::method_29177, registry::method_10221).toString())));
					}
				}))
				.build();
		builder.component(registeredElementBuilder.build());
	}

	static <T extends Enum<T>> void addEnumListToBuilder(String key, List<T> enums, Function<T, class_2561> nameMapper, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		CompositeContainerComponent.Builder enumListBuilder = CompositeContainerComponent.builder();
		if (state.doPrefixSpace()) {
			enumListBuilder.space();
		}
		builder.component(enumListBuilder
				.translate(key, Styler::condition)
				.space()
				.cycle(cycler -> enums.stream()
						.map(nameMapper)
						.map(component -> (class_2561) Styler.name(component.method_27661()))
						.forEach(cycler::textComponent))
				.build());
	}

	static <T> void addTagsToBuilder(String key, List<class_8129<T>> tags, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		CompositeContainerComponent.Builder tagBuilder = CompositeContainerComponent.builder();
		if (state.doPrefixSpace()) {
			tagBuilder.space();
		}
		tagBuilder.translate(tags.size() == 1 ? key : key + ".multiple", Styler::condition)
				.space()
				.cycle(cycler -> tags.forEach(tag -> {
					class_6862<T> tagKey = tag.comp_1836();
					String prefix = tag.comp_1837() ? "" : "!";
					cycler.textComponent(Styler.name(class_2561.method_43470("%s#%s".formatted(prefix, tagKey.comp_327().toString()))));
				}))
				.build();
		builder.component(tagBuilder.build());
	}
}
