//? if >=1.21.8 {
package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_10914;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import net.minecraft.class_9329;
import net.minecraft.class_9331;
import net.minecraft.class_9360;

public interface DataComponentMatchersTooltip {
	static void addToBuilder(class_638 level, class_10914 components, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		if (components.method_68680()) {
			builder.translate(key("any"), Styler::condition);
			return;
		}

		class_9329 exact = components.comp_3833();
		if (!exact.method_68711()) {
			addDataComponentExactPredicateToBuilder(level, exact, state, builder);
		}

		Map<class_9360.class_8745<?>, class_9360> partial = components.comp_3834();
		if (!partial.isEmpty()) {
			addPartialDataComponentPredicatesToBuilder(level, partial, state, builder);
		}
	}

	static String key(String key) {
		return PredicateTooltip.key("data.%s".formatted(key));
	}

	static void addDataComponentExactPredicateToBuilder(class_638 level, class_9329 exact, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		Set<Map.Entry<class_9331<?>, Optional<?>>> entries = exact.method_57870().method_57846();
		if (entries.isEmpty()) {
			builder.translate(key("exact.any"), Styler::condition);
		} else if (entries.size() == 1) {
			Map.Entry<class_9331<?>, Optional<?>> entry = entries.iterator().next();
			Optional<?> value = entry.getValue();
			if (value.isEmpty()) {
				class_2960 key = class_7923.field_49658.method_10221(entry.getKey());
				if (key != null) {
					builder.translate(key("exact.any_for_type"), Styler::condition, Styler.property(class_2561.method_43470(key.toString())));
				} else {
					builder.translate(key("unknown"), Styler::condition);
				}
				return;
			}

			ExactDataComponentPredicateTooltipAdders.addToBuilder(level, entry.getKey(), entry.getValue().orElseThrow(), state, builder);
		} else {
			CompositeContainerComponent.Builder listBuilder = CompositeContainerComponent.builder()
					.vertical()
					.literal(":", Styler::condition);
			for (Map.Entry<class_9331<?>, Optional<?>> entry : entries) {
				Optional<?> value = entry.getValue();
				CompositeContainerComponent.Builder termBuilder = CompositeContainerComponent.builder()
						.space()
						.literal("• ", Styler::condition);
				if (value.isEmpty()) {
					class_2960 key = class_7923.field_49658.method_10221(entry.getKey());
					if (key != null) {
						termBuilder.translate(key("exact.any_for_type"), Styler::condition, Styler.property(class_2561.method_43470(key.toString())));
					} else {
						termBuilder.translate(key("unknown"), Styler::condition);
					}
				} else {
					ExactDataComponentPredicateTooltipAdders.addToBuilder(level, entry.getKey(), entry.getValue().orElse(null), state, termBuilder);
				}
				listBuilder.component(termBuilder.build());
			}
			builder.component(listBuilder.build());
		}
	}

	static void addPartialDataComponentPredicatesToBuilder(class_638 level, Map<class_9360.class_8745<?>, class_9360> partial, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		if (partial.isEmpty()) {
			builder.translate(key("unknown"));
		} else if (partial.size() == 1) {
			Map.Entry<class_9360.class_8745<?>, class_9360> entry = partial.entrySet().iterator().next();
			PartialDataComponentPredicateTooltipAdders.addToBuilder(level, entry.getKey(), entry.getValue(), state, builder);
		} else {
			CompositeContainerComponent.Builder listBuilder = CompositeContainerComponent.builder()
					.vertical()
					.literal(":", Styler::condition);
			for (Map.Entry<class_9360.class_8745<?>, class_9360> entry : partial.entrySet()) {
				CompositeContainerComponent.Builder termBuilder = CompositeContainerComponent.builder()
						.space()
						.literal("• ", Styler::condition);
				PartialDataComponentPredicateTooltipAdders.addToBuilder(level, entry.getKey(), entry.getValue(), state, builder);
				listBuilder.component(termBuilder.build());
			}
			builder.component(listBuilder.build());
		}
	}
}
//?}