package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.exact;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import net.minecraft.class_4174;
import net.minecraft.class_638;

public final class FoodPropertiesExactAdder implements ExactAdder<class_4174> {
	@Override
	public void addToBuilder(class_638 level, class_4174 food, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		boolean canAlwaysEat = food.comp_2493();
		int nutrition = food.comp_2491();
		float saturation = food.comp_2492();

		CompositeContainerComponent.Builder foodBuilder = CompositeContainerComponent.builder()
				.space()
				.translate(key("food"), Styler::condition)
				.space()
				.translate(
						key("food.nutrition"),
						Styler::condition,
						Styler.number(nutrition)
				)
				.space()
				.translate(
						key("food.saturation"),
						Styler::condition,
						Styler.number(saturation)
				);
		if (canAlwaysEat) {
			foodBuilder.space().translate(key("food.can_always_eat"), Styler::condition);
		}
		builder.component(foodBuilder.build());
	}
}
