//? if >=1.21.8 {
package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.exact;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import net.minecraft.class_10590;
import net.minecraft.class_638;

public final class WeaponExactAdder implements ExactAdder<class_10590> {
	@Override
	public void addToBuilder(class_638 level, class_10590 weapon, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		int itemDamagePerAttack = weapon.comp_3481();
		float disableBlockingForSeconds = weapon.comp_3602();
		CompositeContainerComponent.Builder weaponBuilder = CompositeContainerComponent.builder()
				.space()
				.translate(key("weapon"), Styler::condition)
				.space()
				.translate(
						key("weapon.item_damage_per_attack"),
						Styler::condition,
						Styler.number(itemDamagePerAttack)
				)
				.space()
				.translate(
						key("weapon.disable_blocking_for_seconds"),
						Styler::condition,
						Styler.number(disableBlockingForSeconds)
				);
		builder.component(weaponBuilder.build());
	}
}
//?}