package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.partial;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Formatter;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.util.Optional;
import net.minecraft.class_2096;
import net.minecraft.class_638;
import net.minecraft.class_9283;
import net.minecraft.class_9648;
import net.minecraft.class_9657;
import net.minecraft.class_9659;

public final class FireworksPredicatePartialAdder implements PartialAdder</*$ fireworks_predicate >>*/ class_9659 > {
	private final FireworkPredicateAdder predicateAdder = new FireworkPredicateAdder();

	@Override
	public void addToBuilder(class_638 level, /*$ fireworks_predicate >>*/ class_9659 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		class_2096.class_2100 flightDuration = predicate.comp_2637();
		Optional<class_9648<class_9283, /*$ firework_explosion_predicate >>*/ class_9657 .class_9658>> explosions = predicate.comp_2636();

		if (!flightDuration.method_9041()) {
			builder.space()
					.translate(key("fireworks.flight_duration"), Styler::condition);
			PredicateTooltip.addMinMaxToBuilder(
					key("fireworks.flight_duration"),
					false,
					flightDuration,
					v -> Formatter.decimal(v).method_27693("s"),
					state,
					builder
			);
			builder.space()
					.translate("bettertrims.tooltip.and", Styler::condition);
		} else {
			builder.space()
					.translate(key("fireworks.flight_duration.any"), Styler::condition);
		}

		builder.cycle(cycleBuilder -> {
			class_9648<class_9283, /*$ firework_explosion_predicate >>*/ class_9657 .class_9658> fireworkCollection = explosions.orElseThrow();
			CompositeContainerComponent.Builder fireworkBuilder = CompositeContainerComponent.builder();
			addCollectionToBuilder(level, fireworkCollection, "fireworks", predicateAdder, state, fireworkBuilder);
			cycleBuilder.component(fireworkBuilder.build());
		});
	}
}
