//? if fabric {
package com.bawnorton.bettertrims.mixin;

import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.registry.BetterTrimsRegistries;
import com.google.common.collect.ImmutableList;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import net.minecraft.class_7655;

@Mixin(class_7655.class)
abstract class RegistryDataLoaderMixin {
	@Shadow
	@Final
	@Mutable
	public static List<class_7655.class_7657<?>> SYNCHRONIZED_REGISTRIES;

	@Shadow
	@Final
	@Mutable
	public static List<class_7655.class_7657<?>> WORLDGEN_REGISTRIES;

	static {
		ImmutableList.Builder<class_7655.class_7657<?>> synchronizedBuilder = ImmutableList.builder();
		synchronizedBuilder.addAll(SYNCHRONIZED_REGISTRIES);
		synchronizedBuilder.add(new class_7655.class_7657<>(BetterTrimsRegistries.Keys.TRIM_PROPERTIES, TrimProperty.DIRECT_CODEC, false));
		SYNCHRONIZED_REGISTRIES = synchronizedBuilder.build();

		ImmutableList.Builder<class_7655.class_7657<?>> worldgenBuilder = ImmutableList.builder();
		worldgenBuilder.addAll(WORLDGEN_REGISTRIES);
		worldgenBuilder.add(new class_7655.class_7657<>(BetterTrimsRegistries.Keys.TRIM_PROPERTIES, TrimProperty.DIRECT_CODEC, false));
		WORLDGEN_REGISTRIES = worldgenBuilder.build();
	}
}
//?}