package com.bawnorton.bettertrims.mixin.property.ability.armour_effectiveness;

import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.runner.TrimValueAbilityRunner;
import com.bawnorton.bettertrims.property.context.TrimContexts;
import com.bawnorton.bettertrims.property.element.ElementMatcher;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1890.class)
abstract class EnchantmentHelperMixin {
	@ModifyReturnValue(
			method = "modifyArmorEffectiveness",
			at = @At("RETURN")
	)
	private static float applyTrimToArmorEffectiveness(float original, class_3218 level, class_1799 tool, class_1297 entity, class_1282 damageSource) {
		if (!(entity instanceof class_1309 wearer)) return original;

		for (TrimProperty property : TrimProperties.getProperties(level)) {
			for (TrimValueAbilityRunner<?> ability : property.getValueAbilityRunners(TrimAbilityComponents.ARMOUR_EFFECTIVENESS)) {
				original = ability.runDamage(level, wearer, damageSource, original);
			}
		}
		return original;
	}
}
