package com.bawnorton.bettertrims.mixin.property.ability.discount_trades;

import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.runner.TrimValueAbilityRunner;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3988;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3988.class)
abstract class AbstractVillagerMixin extends class_1296 {
	@Shadow
	public abstract class_1916 getOffers();

	AbstractVillagerMixin(class_1299<? extends class_1296> entityType, class_1937 level) {
		super(entityType, level);
	}

	@Inject(
			method = "setTradingPlayer",
			at = @At("TAIL")
	)
	private void applyTrimsToOffers(@Nullable class_1657 player, CallbackInfo ci) {
		if (player == null) return;
		if (!(method_73183() instanceof class_3218 level)) return;

		for (TrimProperty property : TrimProperties.getProperties(level)) {
			for (TrimValueAbilityRunner<?> ability : property.getValueAbilityRunners(TrimAbilityComponents.TRADE_COST)) {
				for (class_1914 offer : getOffers()) {
					int oldCost = offer.method_8246().method_7947();
					int newCost = Math.round(ability.runEquipment(level, player, oldCost));
					offer.method_8245(-(oldCost - newCost));
				}
			}
		}
	}
}

