package com.bawnorton.bettertrims.mixin.property.ability.experience_gain;

import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.runner.TrimValueAbilityRunner;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(class_1657.class)
abstract class PlayerMixin extends class_1309 {
	PlayerMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
		super(entityType, level);
	}

	@ModifyVariable(
			method = "giveExperiencePoints",
			at = @At("HEAD"),
			argsOnly = true
	)
	private int applyTrimToXp(int original) {
		if (!(method_73183() instanceof class_3218 level)) return original;

		for (TrimProperty property : TrimProperties.getProperties(level)) {
			for (TrimValueAbilityRunner<?> ability : property.getValueAbilityRunners(TrimAbilityComponents.EXPERIENCE_GAINED)) {
				original = (int) ability.runEquipment(level, this, original);
			}
		}
		return original;
	}
}
